/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.UpdateResourcePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTemplatePermissionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeTemplatePermissionsResponse> {
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(DescribeTemplatePermissionsResponse.getter(DescribeTemplatePermissionsResponse::templateId)).setter(DescribeTemplatePermissionsResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(DescribeTemplatePermissionsResponse.getter(DescribeTemplatePermissionsResponse::templateArn)).setter(DescribeTemplatePermissionsResponse.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(DescribeTemplatePermissionsResponse.getter(DescribeTemplatePermissionsResponse::permissions)).setter(DescribeTemplatePermissionsResponse.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeTemplatePermissionsResponse.getter(DescribeTemplatePermissionsResponse::requestId)).setter(DescribeTemplatePermissionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeTemplatePermissionsResponse.getter(DescribeTemplatePermissionsResponse::status)).setter(DescribeTemplatePermissionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ID_FIELD, TEMPLATE_ARN_FIELD, PERMISSIONS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String templateId;
    private final String templateArn;
    private final List<ResourcePermission> permissions;
    private final String requestId;
    private final Integer status;

    private DescribeTemplatePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.templateId = builder.templateId;
        this.templateArn = builder.templateArn;
        this.permissions = builder.permissions;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> permissions() {
        return this.permissions;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTemplatePermissionsResponse)) {
            return false;
        }
        DescribeTemplatePermissionsResponse other = (DescribeTemplatePermissionsResponse)((Object)obj);
        return Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.templateArn(), other.templateArn()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTemplatePermissionsResponse").add("TemplateId", (Object)this.templateId()).add("TemplateArn", (Object)this.templateArn()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTemplatePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeTemplatePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String templateId;
        private String templateArn;
        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTemplatePermissionsResponse model) {
            super(model);
            this.templateId(model.templateId);
            this.templateArn(model.templateArn);
            this.permissions(model.permissions);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = UpdateResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = UpdateResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = UpdateResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeTemplatePermissionsResponse build() {
            return new DescribeTemplatePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTemplatePermissionsResponse> {
        public Builder templateId(String var1);

        public Builder templateArn(String var1);

        public Builder permissions(Collection<ResourcePermission> var1);

        public Builder permissions(ResourcePermission ... var1);

        public Builder permissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

