/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qldb.QldbClient;
import software.amazon.awssdk.services.qldb.internal.UserAgentUtils;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsResponse;

public class ListJournalS3ExportsIterable
implements SdkIterable<ListJournalS3ExportsResponse> {
    private final QldbClient client;
    private final ListJournalS3ExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJournalS3ExportsIterable(QldbClient client, ListJournalS3ExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJournalS3ExportsResponseFetcher();
    }

    public Iterator<ListJournalS3ExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListJournalS3ExportsResponseFetcher
    implements SyncPageFetcher<ListJournalS3ExportsResponse> {
        private ListJournalS3ExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListJournalS3ExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJournalS3ExportsResponse nextPage(ListJournalS3ExportsResponse previousPage) {
            if (previousPage == null) {
                return ListJournalS3ExportsIterable.this.client.listJournalS3Exports(ListJournalS3ExportsIterable.this.firstRequest);
            }
            return ListJournalS3ExportsIterable.this.client.listJournalS3Exports((ListJournalS3ExportsRequest)((Object)ListJournalS3ExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

