/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3EncryptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3EncryptionConfiguration> {
    private static final SdkField<String> OBJECT_ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectEncryptionType").getter(S3EncryptionConfiguration.getter(S3EncryptionConfiguration::objectEncryptionTypeAsString)).setter(S3EncryptionConfiguration.setter(Builder::objectEncryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectEncryptionType").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(S3EncryptionConfiguration.getter(S3EncryptionConfiguration::kmsKeyArn)).setter(S3EncryptionConfiguration.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_ENCRYPTION_TYPE_FIELD, KMS_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String objectEncryptionType;
    private final String kmsKeyArn;

    private S3EncryptionConfiguration(BuilderImpl builder) {
        this.objectEncryptionType = builder.objectEncryptionType;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final S3ObjectEncryptionType objectEncryptionType() {
        return S3ObjectEncryptionType.fromValue(this.objectEncryptionType);
    }

    public final String objectEncryptionTypeAsString() {
        return this.objectEncryptionType;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectEncryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3EncryptionConfiguration)) {
            return false;
        }
        S3EncryptionConfiguration other = (S3EncryptionConfiguration)obj;
        return Objects.equals(this.objectEncryptionTypeAsString(), other.objectEncryptionTypeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3EncryptionConfiguration").add("ObjectEncryptionType", (Object)this.objectEncryptionTypeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectEncryptionType": {
                return Optional.ofNullable(clazz.cast(this.objectEncryptionTypeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3EncryptionConfiguration, T> g) {
        return obj -> g.apply((S3EncryptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectEncryptionType;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3EncryptionConfiguration model) {
            this.objectEncryptionType(model.objectEncryptionType);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getObjectEncryptionType() {
            return this.objectEncryptionType;
        }

        public final void setObjectEncryptionType(String objectEncryptionType) {
            this.objectEncryptionType = objectEncryptionType;
        }

        @Override
        public final Builder objectEncryptionType(String objectEncryptionType) {
            this.objectEncryptionType = objectEncryptionType;
            return this;
        }

        @Override
        public final Builder objectEncryptionType(S3ObjectEncryptionType objectEncryptionType) {
            this.objectEncryptionType(objectEncryptionType == null ? null : objectEncryptionType.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public S3EncryptionConfiguration build() {
            return new S3EncryptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3EncryptionConfiguration> {
        public Builder objectEncryptionType(String var1);

        public Builder objectEncryptionType(S3ObjectEncryptionType var1);

        public Builder kmsKeyArn(String var1);
    }
}

