/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapability;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapabilityListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberStatus;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestableNumberType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestPhoneNumberResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, RequestPhoneNumberResponse> {
    private static final SdkField<String> PHONE_NUMBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberArn").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::phoneNumberArn)).setter(RequestPhoneNumberResponse.setter(Builder::phoneNumberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberArn").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberId").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::phoneNumberId)).setter(RequestPhoneNumberResponse.setter(Builder::phoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::phoneNumber)).setter(RequestPhoneNumberResponse.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::statusAsString)).setter(RequestPhoneNumberResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsoCountryCode").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::isoCountryCode)).setter(RequestPhoneNumberResponse.setter(Builder::isoCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::messageTypeAsString)).setter(RequestPhoneNumberResponse.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<List<String>> NUMBER_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NumberCapabilities").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::numberCapabilitiesAsStrings)).setter(RequestPhoneNumberResponse.setter(Builder::numberCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NUMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberType").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::numberTypeAsString)).setter(RequestPhoneNumberResponse.setter(Builder::numberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberType").build()}).build();
    private static final SdkField<String> MONTHLY_LEASING_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonthlyLeasingPrice").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::monthlyLeasingPrice)).setter(RequestPhoneNumberResponse.setter(Builder::monthlyLeasingPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlyLeasingPrice").build()}).build();
    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TwoWayEnabled").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::twoWayEnabled)).setter(RequestPhoneNumberResponse.setter(Builder::twoWayEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()}).build();
    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TwoWayChannelArn").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::twoWayChannelArn)).setter(RequestPhoneNumberResponse.setter(Builder::twoWayChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()}).build();
    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::selfManagedOptOutsEnabled)).setter(RequestPhoneNumberResponse.setter(Builder::selfManagedOptOutsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build()}).build();
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListName").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::optOutListName)).setter(RequestPhoneNumberResponse.setter(Builder::optOutListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::deletionProtectionEnabled)).setter(RequestPhoneNumberResponse.setter(Builder::deletionProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::poolId)).setter(RequestPhoneNumberResponse.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::tags)).setter(RequestPhoneNumberResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(RequestPhoneNumberResponse.getter(RequestPhoneNumberResponse::createdTimestamp)).setter(RequestPhoneNumberResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ARN_FIELD, PHONE_NUMBER_ID_FIELD, PHONE_NUMBER_FIELD, STATUS_FIELD, ISO_COUNTRY_CODE_FIELD, MESSAGE_TYPE_FIELD, NUMBER_CAPABILITIES_FIELD, NUMBER_TYPE_FIELD, MONTHLY_LEASING_PRICE_FIELD, TWO_WAY_ENABLED_FIELD, TWO_WAY_CHANNEL_ARN_FIELD, SELF_MANAGED_OPT_OUTS_ENABLED_FIELD, OPT_OUT_LIST_NAME_FIELD, DELETION_PROTECTION_ENABLED_FIELD, POOL_ID_FIELD, TAGS_FIELD, CREATED_TIMESTAMP_FIELD));
    private final String phoneNumberArn;
    private final String phoneNumberId;
    private final String phoneNumber;
    private final String status;
    private final String isoCountryCode;
    private final String messageType;
    private final List<String> numberCapabilities;
    private final String numberType;
    private final String monthlyLeasingPrice;
    private final Boolean twoWayEnabled;
    private final String twoWayChannelArn;
    private final Boolean selfManagedOptOutsEnabled;
    private final String optOutListName;
    private final Boolean deletionProtectionEnabled;
    private final String poolId;
    private final List<Tag> tags;
    private final Instant createdTimestamp;

    private RequestPhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberArn = builder.phoneNumberArn;
        this.phoneNumberId = builder.phoneNumberId;
        this.phoneNumber = builder.phoneNumber;
        this.status = builder.status;
        this.isoCountryCode = builder.isoCountryCode;
        this.messageType = builder.messageType;
        this.numberCapabilities = builder.numberCapabilities;
        this.numberType = builder.numberType;
        this.monthlyLeasingPrice = builder.monthlyLeasingPrice;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.poolId = builder.poolId;
        this.tags = builder.tags;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String phoneNumberArn() {
        return this.phoneNumberArn;
    }

    public final String phoneNumberId() {
        return this.phoneNumberId;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final NumberStatus status() {
        return NumberStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String isoCountryCode() {
        return this.isoCountryCode;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final List<NumberCapability> numberCapabilities() {
        return NumberCapabilityListCopier.copyStringToEnum(this.numberCapabilities);
    }

    public final boolean hasNumberCapabilities() {
        return this.numberCapabilities != null && !(this.numberCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> numberCapabilitiesAsStrings() {
        return this.numberCapabilities;
    }

    public final RequestableNumberType numberType() {
        return RequestableNumberType.fromValue(this.numberType);
    }

    public final String numberTypeAsString() {
        return this.numberType;
    }

    public final String monthlyLeasingPrice() {
        return this.monthlyLeasingPrice;
    }

    public final Boolean twoWayEnabled() {
        return this.twoWayEnabled;
    }

    public final String twoWayChannelArn() {
        return this.twoWayChannelArn;
    }

    public final Boolean selfManagedOptOutsEnabled() {
        return this.selfManagedOptOutsEnabled;
    }

    public final String optOutListName() {
        return this.optOutListName;
    }

    public final Boolean deletionProtectionEnabled() {
        return this.deletionProtectionEnabled;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumberCapabilities() ? this.numberCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlyLeasingPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestPhoneNumberResponse)) {
            return false;
        }
        RequestPhoneNumberResponse other = (RequestPhoneNumberResponse)((Object)obj);
        return Objects.equals(this.phoneNumberArn(), other.phoneNumberArn()) && Objects.equals(this.phoneNumberId(), other.phoneNumberId()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.isoCountryCode(), other.isoCountryCode()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && this.hasNumberCapabilities() == other.hasNumberCapabilities() && Objects.equals(this.numberCapabilitiesAsStrings(), other.numberCapabilitiesAsStrings()) && Objects.equals(this.numberTypeAsString(), other.numberTypeAsString()) && Objects.equals(this.monthlyLeasingPrice(), other.monthlyLeasingPrice()) && Objects.equals(this.twoWayEnabled(), other.twoWayEnabled()) && Objects.equals(this.twoWayChannelArn(), other.twoWayChannelArn()) && Objects.equals(this.selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled()) && Objects.equals(this.optOutListName(), other.optOutListName()) && Objects.equals(this.deletionProtectionEnabled(), other.deletionProtectionEnabled()) && Objects.equals(this.poolId(), other.poolId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"RequestPhoneNumberResponse").add("PhoneNumberArn", (Object)this.phoneNumberArn()).add("PhoneNumberId", (Object)this.phoneNumberId()).add("PhoneNumber", (Object)this.phoneNumber()).add("Status", (Object)this.statusAsString()).add("IsoCountryCode", (Object)this.isoCountryCode()).add("MessageType", (Object)this.messageTypeAsString()).add("NumberCapabilities", this.hasNumberCapabilities() ? this.numberCapabilitiesAsStrings() : null).add("NumberType", (Object)this.numberTypeAsString()).add("MonthlyLeasingPrice", (Object)this.monthlyLeasingPrice()).add("TwoWayEnabled", (Object)this.twoWayEnabled()).add("TwoWayChannelArn", (Object)this.twoWayChannelArn()).add("SelfManagedOptOutsEnabled", (Object)this.selfManagedOptOutsEnabled()).add("OptOutListName", (Object)this.optOutListName()).add("DeletionProtectionEnabled", (Object)this.deletionProtectionEnabled()).add("PoolId", (Object)this.poolId()).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberArn": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberArn()));
            }
            case "PhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberId()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "IsoCountryCode": {
                return Optional.ofNullable(clazz.cast(this.isoCountryCode()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "NumberCapabilities": {
                return Optional.ofNullable(clazz.cast(this.numberCapabilitiesAsStrings()));
            }
            case "NumberType": {
                return Optional.ofNullable(clazz.cast(this.numberTypeAsString()));
            }
            case "MonthlyLeasingPrice": {
                return Optional.ofNullable(clazz.cast(this.monthlyLeasingPrice()));
            }
            case "TwoWayEnabled": {
                return Optional.ofNullable(clazz.cast(this.twoWayEnabled()));
            }
            case "TwoWayChannelArn": {
                return Optional.ofNullable(clazz.cast(this.twoWayChannelArn()));
            }
            case "SelfManagedOptOutsEnabled": {
                return Optional.ofNullable(clazz.cast(this.selfManagedOptOutsEnabled()));
            }
            case "OptOutListName": {
                return Optional.ofNullable(clazz.cast(this.optOutListName()));
            }
            case "DeletionProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionEnabled()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestPhoneNumberResponse, T> g) {
        return obj -> g.apply((RequestPhoneNumberResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String phoneNumberArn;
        private String phoneNumberId;
        private String phoneNumber;
        private String status;
        private String isoCountryCode;
        private String messageType;
        private List<String> numberCapabilities = DefaultSdkAutoConstructList.getInstance();
        private String numberType;
        private String monthlyLeasingPrice;
        private Boolean twoWayEnabled;
        private String twoWayChannelArn;
        private Boolean selfManagedOptOutsEnabled;
        private String optOutListName;
        private Boolean deletionProtectionEnabled;
        private String poolId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestPhoneNumberResponse model) {
            super(model);
            this.phoneNumberArn(model.phoneNumberArn);
            this.phoneNumberId(model.phoneNumberId);
            this.phoneNumber(model.phoneNumber);
            this.status(model.status);
            this.isoCountryCode(model.isoCountryCode);
            this.messageType(model.messageType);
            this.numberCapabilitiesWithStrings(model.numberCapabilities);
            this.numberType(model.numberType);
            this.monthlyLeasingPrice(model.monthlyLeasingPrice);
            this.twoWayEnabled(model.twoWayEnabled);
            this.twoWayChannelArn(model.twoWayChannelArn);
            this.selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            this.optOutListName(model.optOutListName);
            this.deletionProtectionEnabled(model.deletionProtectionEnabled);
            this.poolId(model.poolId);
            this.tags(model.tags);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getPhoneNumberArn() {
            return this.phoneNumberArn;
        }

        public final void setPhoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
        }

        @Override
        public final Builder phoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
            return this;
        }

        public final String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NumberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Collection<String> getNumberCapabilities() {
            if (this.numberCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.numberCapabilities;
        }

        public final void setNumberCapabilities(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
        }

        @Override
        public final Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilitiesWithStrings(String ... numberCapabilities) {
            this.numberCapabilitiesWithStrings(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        public final Builder numberCapabilities(Collection<NumberCapability> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copyEnumToString(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilities(NumberCapability ... numberCapabilities) {
            this.numberCapabilities(Arrays.asList(numberCapabilities));
            return this;
        }

        public final String getNumberType() {
            return this.numberType;
        }

        public final void setNumberType(String numberType) {
            this.numberType = numberType;
        }

        @Override
        public final Builder numberType(String numberType) {
            this.numberType = numberType;
            return this;
        }

        @Override
        public final Builder numberType(RequestableNumberType numberType) {
            this.numberType(numberType == null ? null : numberType.toString());
            return this;
        }

        public final String getMonthlyLeasingPrice() {
            return this.monthlyLeasingPrice;
        }

        public final void setMonthlyLeasingPrice(String monthlyLeasingPrice) {
            this.monthlyLeasingPrice = monthlyLeasingPrice;
        }

        @Override
        public final Builder monthlyLeasingPrice(String monthlyLeasingPrice) {
            this.monthlyLeasingPrice = monthlyLeasingPrice;
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return this.twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return this.twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return this.selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return this.optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public RequestPhoneNumberResponse build() {
            return new RequestPhoneNumberResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestPhoneNumberResponse> {
        public Builder phoneNumberArn(String var1);

        public Builder phoneNumberId(String var1);

        public Builder phoneNumber(String var1);

        public Builder status(String var1);

        public Builder status(NumberStatus var1);

        public Builder isoCountryCode(String var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder numberCapabilitiesWithStrings(Collection<String> var1);

        public Builder numberCapabilitiesWithStrings(String ... var1);

        public Builder numberCapabilities(Collection<NumberCapability> var1);

        public Builder numberCapabilities(NumberCapability ... var1);

        public Builder numberType(String var1);

        public Builder numberType(RequestableNumberType var1);

        public Builder monthlyLeasingPrice(String var1);

        public Builder twoWayEnabled(Boolean var1);

        public Builder twoWayChannelArn(String var1);

        public Builder selfManagedOptOutsEnabled(Boolean var1);

        public Builder optOutListName(String var1);

        public Builder deletionProtectionEnabled(Boolean var1);

        public Builder poolId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);
    }
}

