/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.waiters.LambdaWaiter;
import software.amazon.awssdk.services.lambda.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultLambdaWaiter
implements LambdaWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final LambdaClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetFunctionResponse> functionExistsWaiter;
    private final Waiter<GetFunctionConfigurationResponse> functionActiveWaiter;
    private final Waiter<GetFunctionConfigurationResponse> functionUpdatedWaiter;
    private final Waiter<GetFunctionResponse> functionActiveV2Waiter;
    private final Waiter<GetFunctionResponse> functionUpdatedV2Waiter;
    private final Waiter<GetFunctionConfigurationResponse> publishedVersionActiveWaiter;

    private DefaultLambdaWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (LambdaClient)LambdaClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.functionExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetFunctionResponse.class).acceptors(DefaultLambdaWaiter.functionExistsWaiterAcceptors())).overrideConfiguration(DefaultLambdaWaiter.functionExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.functionActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetFunctionConfigurationResponse.class).acceptors(DefaultLambdaWaiter.functionActiveWaiterAcceptors())).overrideConfiguration(DefaultLambdaWaiter.functionActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.functionUpdatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetFunctionConfigurationResponse.class).acceptors(DefaultLambdaWaiter.functionUpdatedWaiterAcceptors())).overrideConfiguration(DefaultLambdaWaiter.functionUpdatedWaiterConfig(builder.overrideConfiguration))).build();
        this.functionActiveV2Waiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetFunctionResponse.class).acceptors(DefaultLambdaWaiter.functionActiveV2WaiterAcceptors())).overrideConfiguration(DefaultLambdaWaiter.functionActiveV2WaiterConfig(builder.overrideConfiguration))).build();
        this.functionUpdatedV2Waiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetFunctionResponse.class).acceptors(DefaultLambdaWaiter.functionUpdatedV2WaiterAcceptors())).overrideConfiguration(DefaultLambdaWaiter.functionUpdatedV2WaiterConfig(builder.overrideConfiguration))).build();
        this.publishedVersionActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetFunctionConfigurationResponse.class).acceptors(DefaultLambdaWaiter.publishedVersionActiveWaiterAcceptors())).overrideConfiguration(DefaultLambdaWaiter.publishedVersionActiveWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetFunctionConfigurationResponse> waitUntilFunctionActive(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        return this.functionActiveWaiter.run(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)));
    }

    @Override
    public WaiterResponse<GetFunctionConfigurationResponse> waitUntilFunctionActive(GetFunctionConfigurationRequest getFunctionConfigurationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.functionActiveWaiter.run(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)), DefaultLambdaWaiter.functionActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetFunctionResponse> waitUntilFunctionActiveV2(GetFunctionRequest getFunctionRequest) {
        return this.functionActiveV2Waiter.run(() -> this.client.getFunction(this.applyWaitersUserAgent(getFunctionRequest)));
    }

    @Override
    public WaiterResponse<GetFunctionResponse> waitUntilFunctionActiveV2(GetFunctionRequest getFunctionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.functionActiveV2Waiter.run(() -> this.client.getFunction(this.applyWaitersUserAgent(getFunctionRequest)), DefaultLambdaWaiter.functionActiveV2WaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetFunctionResponse> waitUntilFunctionExists(GetFunctionRequest getFunctionRequest) {
        return this.functionExistsWaiter.run(() -> this.client.getFunction(this.applyWaitersUserAgent(getFunctionRequest)));
    }

    @Override
    public WaiterResponse<GetFunctionResponse> waitUntilFunctionExists(GetFunctionRequest getFunctionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.functionExistsWaiter.run(() -> this.client.getFunction(this.applyWaitersUserAgent(getFunctionRequest)), DefaultLambdaWaiter.functionExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetFunctionConfigurationResponse> waitUntilFunctionUpdated(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        return this.functionUpdatedWaiter.run(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)));
    }

    @Override
    public WaiterResponse<GetFunctionConfigurationResponse> waitUntilFunctionUpdated(GetFunctionConfigurationRequest getFunctionConfigurationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.functionUpdatedWaiter.run(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)), DefaultLambdaWaiter.functionUpdatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetFunctionResponse> waitUntilFunctionUpdatedV2(GetFunctionRequest getFunctionRequest) {
        return this.functionUpdatedV2Waiter.run(() -> this.client.getFunction(this.applyWaitersUserAgent(getFunctionRequest)));
    }

    @Override
    public WaiterResponse<GetFunctionResponse> waitUntilFunctionUpdatedV2(GetFunctionRequest getFunctionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.functionUpdatedV2Waiter.run(() -> this.client.getFunction(this.applyWaitersUserAgent(getFunctionRequest)), DefaultLambdaWaiter.functionUpdatedV2WaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetFunctionConfigurationResponse> waitUntilPublishedVersionActive(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        return this.publishedVersionActiveWaiter.run(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)));
    }

    @Override
    public WaiterResponse<GetFunctionConfigurationResponse> waitUntilPublishedVersionActive(GetFunctionConfigurationRequest getFunctionConfigurationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.publishedVersionActiveWaiter.run(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)), DefaultLambdaWaiter.publishedVersionActiveWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetFunctionResponse>> functionExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultLambdaWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetFunctionConfigurationResponse>> functionActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Active");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Pending");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetFunctionConfigurationResponse>> functionUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("LastUpdateStatus").value(), "Successful");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("LastUpdateStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (LastUpdateStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("LastUpdateStatus").value(), "InProgress");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetFunctionResponse>> functionActiveV2WaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Configuration").field("State").value(), "Active");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Configuration").field("State").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Configuration.State=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Configuration").field("State").value(), "Pending");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetFunctionResponse>> functionUpdatedV2WaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Configuration").field("LastUpdateStatus").value(), "Successful");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Configuration").field("LastUpdateStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Configuration.LastUpdateStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Configuration").field("LastUpdateStatus").value(), "InProgress");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetFunctionConfigurationResponse>> publishedVersionActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Active");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Pending");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration functionExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration functionActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration functionUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration functionActiveV2WaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(300);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration functionUpdatedV2WaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(300);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration publishedVersionActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(312);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static LambdaWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends LambdaRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LambdaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements LambdaWaiter.Builder {
        private LambdaClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public LambdaWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public LambdaWaiter.Builder client(LambdaClient client) {
            this.client = client;
            return this;
        }

        @Override
        public LambdaWaiter build() {
            return new DefaultLambdaWaiter(this);
        }
    }
}

