/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.SuggestionHighlight;
import software.amazon.awssdk.services.kendra.model.SuggestionHighlightListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestionTextWithHighlights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuggestionTextWithHighlights> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SuggestionTextWithHighlights.getter(SuggestionTextWithHighlights::text)).setter(SuggestionTextWithHighlights.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<List<SuggestionHighlight>> HIGHLIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Highlights").getter(SuggestionTextWithHighlights.getter(SuggestionTextWithHighlights::highlights)).setter(SuggestionTextWithHighlights.setter(Builder::highlights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuggestionHighlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, HIGHLIGHTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String text;
    private final List<SuggestionHighlight> highlights;

    private SuggestionTextWithHighlights(BuilderImpl builder) {
        this.text = builder.text;
        this.highlights = builder.highlights;
    }

    public final String text() {
        return this.text;
    }

    public final boolean hasHighlights() {
        return this.highlights != null && !(this.highlights instanceof SdkAutoConstructList);
    }

    public final List<SuggestionHighlight> highlights() {
        return this.highlights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHighlights() ? this.highlights() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestionTextWithHighlights)) {
            return false;
        }
        SuggestionTextWithHighlights other = (SuggestionTextWithHighlights)obj;
        return Objects.equals(this.text(), other.text()) && this.hasHighlights() == other.hasHighlights() && Objects.equals(this.highlights(), other.highlights());
    }

    public final String toString() {
        return ToString.builder((String)"SuggestionTextWithHighlights").add("Text", (Object)this.text()).add("Highlights", this.hasHighlights() ? this.highlights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Highlights": {
                return Optional.ofNullable(clazz.cast(this.highlights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestionTextWithHighlights, T> g) {
        return obj -> g.apply((SuggestionTextWithHighlights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private List<SuggestionHighlight> highlights = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestionTextWithHighlights model) {
            this.text(model.text);
            this.highlights(model.highlights);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final List<SuggestionHighlight.Builder> getHighlights() {
            List<SuggestionHighlight.Builder> result = SuggestionHighlightListCopier.copyToBuilder(this.highlights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHighlights(Collection<SuggestionHighlight.BuilderImpl> highlights) {
            this.highlights = SuggestionHighlightListCopier.copyFromBuilder(highlights);
        }

        @Override
        public final Builder highlights(Collection<SuggestionHighlight> highlights) {
            this.highlights = SuggestionHighlightListCopier.copy(highlights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder highlights(SuggestionHighlight ... highlights) {
            this.highlights(Arrays.asList(highlights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder highlights(Consumer<SuggestionHighlight.Builder> ... highlights) {
            this.highlights(Stream.of(highlights).map(c -> (SuggestionHighlight)((SuggestionHighlight.Builder)SuggestionHighlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SuggestionTextWithHighlights build() {
            return new SuggestionTextWithHighlights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuggestionTextWithHighlights> {
        public Builder text(String var1);

        public Builder highlights(Collection<SuggestionHighlight> var1);

        public Builder highlights(SuggestionHighlight ... var1);

        public Builder highlights(Consumer<SuggestionHighlight.Builder> ... var1);
    }
}

