/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanStatusCode {
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanStatusCode> VALUE_MAP;
    private final String value;

    private ScanStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanStatusCode> knownValues() {
        EnumSet<ScanStatusCode> knownValues = EnumSet.allOf(ScanStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanStatusCode.class, ScanStatusCode::toString);
    }
}

