/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageManager {
    BUNDLER("BUNDLER"),
    CARGO("CARGO"),
    COMPOSER("COMPOSER"),
    NPM("NPM"),
    NUGET("NUGET"),
    PIPENV("PIPENV"),
    POETRY("POETRY"),
    YARN("YARN"),
    GOBINARY("GOBINARY"),
    GOMOD("GOMOD"),
    JAR("JAR"),
    OS("OS"),
    PIP("PIP"),
    PYTHONPKG("PYTHONPKG"),
    NODEPKG("NODEPKG"),
    POM("POM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageManager> VALUE_MAP;
    private final String value;

    private PackageManager(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageManager fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageManager> knownValues() {
        EnumSet<PackageManager> knownValues = EnumSet.allOf(PackageManager.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageManager.class, PackageManager::toString);
    }
}

