/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a specific trigger.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Trigger implements SdkPojo, Serializable, ToCopyableBuilder<Trigger.Builder, Trigger> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Trigger::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowName").getter(getter(Trigger::workflowName)).setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Trigger::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Trigger::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Trigger::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Trigger::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(Trigger::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(Trigger::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.<Predicate> builder(MarshallingType.SDK_POJO)
            .memberName("Predicate").getter(getter(Trigger::predicate)).setter(setter(Builder::predicate))
            .constructor(Predicate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()).build();

    private static final SdkField<EventBatchingCondition> EVENT_BATCHING_CONDITION_FIELD = SdkField
            .<EventBatchingCondition> builder(MarshallingType.SDK_POJO).memberName("EventBatchingCondition")
            .getter(getter(Trigger::eventBatchingCondition)).setter(setter(Builder::eventBatchingCondition))
            .constructor(EventBatchingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBatchingCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            WORKFLOW_NAME_FIELD, ID_FIELD, TYPE_FIELD, STATE_FIELD, DESCRIPTION_FIELD, SCHEDULE_FIELD, ACTIONS_FIELD,
            PREDICATE_FIELD, EVENT_BATCHING_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String workflowName;

    private final String id;

    private final String type;

    private final String state;

    private final String description;

    private final String schedule;

    private final List<Action> actions;

    private final Predicate predicate;

    private final EventBatchingCondition eventBatchingCondition;

    private Trigger(BuilderImpl builder) {
        this.name = builder.name;
        this.workflowName = builder.workflowName;
        this.id = builder.id;
        this.type = builder.type;
        this.state = builder.state;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.actions = builder.actions;
        this.predicate = builder.predicate;
        this.eventBatchingCondition = builder.eventBatchingCondition;
    }

    /**
     * <p>
     * The name of the trigger.
     * </p>
     * 
     * @return The name of the trigger.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the workflow associated with the trigger.
     * </p>
     * 
     * @return The name of the workflow associated with the trigger.
     */
    public final String workflowName() {
        return workflowName;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of trigger that this is.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of trigger that this is.
     * @see TriggerType
     */
    public final TriggerType type() {
        return TriggerType.fromValue(type);
    }

    /**
     * <p>
     * The type of trigger that this is.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of trigger that this is.
     * @see TriggerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The current state of the trigger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TriggerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the trigger.
     * @see TriggerState
     */
    public final TriggerState state() {
        return TriggerState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the trigger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TriggerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the trigger.
     * @see TriggerState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A description of this trigger.
     * </p>
     * 
     * @return A description of this trigger.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A <code>cron</code> expression used to specify the schedule (see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for
     * Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
     * <code>cron(15 12 * * ? *)</code>.
     * </p>
     * 
     * @return A <code>cron</code> expression used to specify the schedule (see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
     *         Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
     *         specify: <code>cron(15 12 * * ? *)</code>.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions initiated by this trigger.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions initiated by this trigger.
     */
    public final List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * The predicate of this trigger, which defines when it will fire.
     * </p>
     * 
     * @return The predicate of this trigger, which defines when it will fire.
     */
    public final Predicate predicate() {
        return predicate;
    }

    /**
     * <p>
     * Batch condition that must be met (specified number of events received or batch time window expired) before
     * EventBridge event trigger fires.
     * </p>
     * 
     * @return Batch condition that must be met (specified number of events received or batch time window expired)
     *         before EventBridge event trigger fires.
     */
    public final EventBatchingCondition eventBatchingCondition() {
        return eventBatchingCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(predicate());
        hashCode = 31 * hashCode + Objects.hashCode(eventBatchingCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(workflowName(), other.workflowName())
                && Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(schedule(), other.schedule()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions()) && Objects.equals(predicate(), other.predicate())
                && Objects.equals(eventBatchingCondition(), other.eventBatchingCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Trigger").add("Name", name()).add("WorkflowName", workflowName()).add("Id", id())
                .add("Type", typeAsString()).add("State", stateAsString()).add("Description", description())
                .add("Schedule", schedule()).add("Actions", hasActions() ? actions() : null).add("Predicate", predicate())
                .add("EventBatchingCondition", eventBatchingCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "WorkflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "Predicate":
            return Optional.ofNullable(clazz.cast(predicate()));
        case "EventBatchingCondition":
            return Optional.ofNullable(clazz.cast(eventBatchingCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("WorkflowName", WORKFLOW_NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("Predicate", PREDICATE_FIELD);
        map.put("EventBatchingCondition", EVENT_BATCHING_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Trigger, T> g) {
        return obj -> g.apply((Trigger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Trigger> {
        /**
         * <p>
         * The name of the trigger.
         * </p>
         * 
         * @param name
         *        The name of the trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the workflow associated with the trigger.
         * </p>
         * 
         * @param workflowName
         *        The name of the workflow associated with the trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param id
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of trigger that this is.
         * </p>
         * 
         * @param type
         *        The type of trigger that this is.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of trigger that this is.
         * </p>
         * 
         * @param type
         *        The type of trigger that this is.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder type(TriggerType type);

        /**
         * <p>
         * The current state of the trigger.
         * </p>
         * 
         * @param state
         *        The current state of the trigger.
         * @see TriggerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the trigger.
         * </p>
         * 
         * @param state
         *        The current state of the trigger.
         * @see TriggerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerState
         */
        Builder state(TriggerState state);

        /**
         * <p>
         * A description of this trigger.
         * </p>
         * 
         * @param description
         *        A description of this trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A <code>cron</code> expression used to specify the schedule (see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules
         * for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
         * <code>cron(15 12 * * ? *)</code>.
         * </p>
         * 
         * @param schedule
         *        A <code>cron</code> expression used to specify the schedule (see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
         *        Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
         *        specify: <code>cron(15 12 * * ? *)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The actions initiated by this trigger.
         * </p>
         * 
         * @param actions
         *        The actions initiated by this trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions initiated by this trigger.
         * </p>
         * 
         * @param actions
         *        The actions initiated by this trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions initiated by this trigger.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Action.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Action.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.glue.model.Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * The predicate of this trigger, which defines when it will fire.
         * </p>
         * 
         * @param predicate
         *        The predicate of this trigger, which defines when it will fire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicate(Predicate predicate);

        /**
         * <p>
         * The predicate of this trigger, which defines when it will fire.
         * </p>
         * This is a convenience method that creates an instance of the {@link Predicate.Builder} avoiding the need to
         * create one manually via {@link Predicate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Predicate.Builder#build()} is called immediately and its result
         * is passed to {@link #predicate(Predicate)}.
         * 
         * @param predicate
         *        a consumer that will call methods on {@link Predicate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predicate(Predicate)
         */
        default Builder predicate(Consumer<Predicate.Builder> predicate) {
            return predicate(Predicate.builder().applyMutation(predicate).build());
        }

        /**
         * <p>
         * Batch condition that must be met (specified number of events received or batch time window expired) before
         * EventBridge event trigger fires.
         * </p>
         * 
         * @param eventBatchingCondition
         *        Batch condition that must be met (specified number of events received or batch time window expired)
         *        before EventBridge event trigger fires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBatchingCondition(EventBatchingCondition eventBatchingCondition);

        /**
         * <p>
         * Batch condition that must be met (specified number of events received or batch time window expired) before
         * EventBridge event trigger fires.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventBatchingCondition.Builder} avoiding
         * the need to create one manually via {@link EventBatchingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventBatchingCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #eventBatchingCondition(EventBatchingCondition)}.
         * 
         * @param eventBatchingCondition
         *        a consumer that will call methods on {@link EventBatchingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBatchingCondition(EventBatchingCondition)
         */
        default Builder eventBatchingCondition(Consumer<EventBatchingCondition.Builder> eventBatchingCondition) {
            return eventBatchingCondition(EventBatchingCondition.builder().applyMutation(eventBatchingCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String workflowName;

        private String id;

        private String type;

        private String state;

        private String description;

        private String schedule;

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private Predicate predicate;

        private EventBatchingCondition eventBatchingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(Trigger model) {
            name(model.name);
            workflowName(model.workflowName);
            id(model.id);
            type(model.type);
            state(model.state);
            description(model.description);
            schedule(model.schedule);
            actions(model.actions);
            predicate(model.predicate);
            eventBatchingCondition(model.eventBatchingCondition);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TriggerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TriggerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Predicate.Builder getPredicate() {
            return predicate != null ? predicate.toBuilder() : null;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final EventBatchingCondition.Builder getEventBatchingCondition() {
            return eventBatchingCondition != null ? eventBatchingCondition.toBuilder() : null;
        }

        public final void setEventBatchingCondition(EventBatchingCondition.BuilderImpl eventBatchingCondition) {
            this.eventBatchingCondition = eventBatchingCondition != null ? eventBatchingCondition.build() : null;
        }

        @Override
        public final Builder eventBatchingCondition(EventBatchingCondition eventBatchingCondition) {
            this.eventBatchingCondition = eventBatchingCondition;
            return this;
        }

        @Override
        public Trigger build() {
            return new Trigger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
