/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The algorithm-specific parameters that are associated with the machine learning transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformParameters.Builder, TransformParameters> {
    private static final SdkField<String> TRANSFORM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformType").getter(getter(TransformParameters::transformTypeAsString))
            .setter(setter(Builder::transformType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformType").build()).build();

    private static final SdkField<FindMatchesParameters> FIND_MATCHES_PARAMETERS_FIELD = SdkField
            .<FindMatchesParameters> builder(MarshallingType.SDK_POJO).memberName("FindMatchesParameters")
            .getter(getter(TransformParameters::findMatchesParameters)).setter(setter(Builder::findMatchesParameters))
            .constructor(FindMatchesParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindMatchesParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_TYPE_FIELD,
            FIND_MATCHES_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transformType;

    private final FindMatchesParameters findMatchesParameters;

    private TransformParameters(BuilderImpl builder) {
        this.transformType = builder.transformType;
        this.findMatchesParameters = builder.findMatchesParameters;
    }

    /**
     * <p>
     * The type of machine learning transform.
     * </p>
     * <p>
     * For information about the types of machine learning transforms, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine
     * Learning Transforms</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transformType}
     * will return {@link TransformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transformTypeAsString}.
     * </p>
     * 
     * @return The type of machine learning transform.</p>
     *         <p>
     *         For information about the types of machine learning transforms, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating
     *         Machine Learning Transforms</a>.
     * @see TransformType
     */
    public final TransformType transformType() {
        return TransformType.fromValue(transformType);
    }

    /**
     * <p>
     * The type of machine learning transform.
     * </p>
     * <p>
     * For information about the types of machine learning transforms, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine
     * Learning Transforms</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transformType}
     * will return {@link TransformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transformTypeAsString}.
     * </p>
     * 
     * @return The type of machine learning transform.</p>
     *         <p>
     *         For information about the types of machine learning transforms, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating
     *         Machine Learning Transforms</a>.
     * @see TransformType
     */
    public final String transformTypeAsString() {
        return transformType;
    }

    /**
     * <p>
     * The parameters for the find matches algorithm.
     * </p>
     * 
     * @return The parameters for the find matches algorithm.
     */
    public final FindMatchesParameters findMatchesParameters() {
        return findMatchesParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(findMatchesParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformParameters)) {
            return false;
        }
        TransformParameters other = (TransformParameters) obj;
        return Objects.equals(transformTypeAsString(), other.transformTypeAsString())
                && Objects.equals(findMatchesParameters(), other.findMatchesParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformParameters").add("TransformType", transformTypeAsString())
                .add("FindMatchesParameters", findMatchesParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformType":
            return Optional.ofNullable(clazz.cast(transformTypeAsString()));
        case "FindMatchesParameters":
            return Optional.ofNullable(clazz.cast(findMatchesParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransformType", TRANSFORM_TYPE_FIELD);
        map.put("FindMatchesParameters", FIND_MATCHES_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformParameters, T> g) {
        return obj -> g.apply((TransformParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformParameters> {
        /**
         * <p>
         * The type of machine learning transform.
         * </p>
         * <p>
         * For information about the types of machine learning transforms, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine
         * Learning Transforms</a>.
         * </p>
         * 
         * @param transformType
         *        The type of machine learning transform.</p>
         *        <p>
         *        For information about the types of machine learning transforms, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating
         *        Machine Learning Transforms</a>.
         * @see TransformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformType
         */
        Builder transformType(String transformType);

        /**
         * <p>
         * The type of machine learning transform.
         * </p>
         * <p>
         * For information about the types of machine learning transforms, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine
         * Learning Transforms</a>.
         * </p>
         * 
         * @param transformType
         *        The type of machine learning transform.</p>
         *        <p>
         *        For information about the types of machine learning transforms, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating
         *        Machine Learning Transforms</a>.
         * @see TransformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformType
         */
        Builder transformType(TransformType transformType);

        /**
         * <p>
         * The parameters for the find matches algorithm.
         * </p>
         * 
         * @param findMatchesParameters
         *        The parameters for the find matches algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findMatchesParameters(FindMatchesParameters findMatchesParameters);

        /**
         * <p>
         * The parameters for the find matches algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindMatchesParameters.Builder} avoiding
         * the need to create one manually via {@link FindMatchesParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindMatchesParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #findMatchesParameters(FindMatchesParameters)}.
         * 
         * @param findMatchesParameters
         *        a consumer that will call methods on {@link FindMatchesParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findMatchesParameters(FindMatchesParameters)
         */
        default Builder findMatchesParameters(Consumer<FindMatchesParameters.Builder> findMatchesParameters) {
            return findMatchesParameters(FindMatchesParameters.builder().applyMutation(findMatchesParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String transformType;

        private FindMatchesParameters findMatchesParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformParameters model) {
            transformType(model.transformType);
            findMatchesParameters(model.findMatchesParameters);
        }

        public final String getTransformType() {
            return transformType;
        }

        public final void setTransformType(String transformType) {
            this.transformType = transformType;
        }

        @Override
        public final Builder transformType(String transformType) {
            this.transformType = transformType;
            return this;
        }

        @Override
        public final Builder transformType(TransformType transformType) {
            this.transformType(transformType == null ? null : transformType.toString());
            return this;
        }

        public final FindMatchesParameters.Builder getFindMatchesParameters() {
            return findMatchesParameters != null ? findMatchesParameters.toBuilder() : null;
        }

        public final void setFindMatchesParameters(FindMatchesParameters.BuilderImpl findMatchesParameters) {
            this.findMatchesParameters = findMatchesParameters != null ? findMatchesParameters.build() : null;
        }

        @Override
        public final Builder findMatchesParameters(FindMatchesParameters findMatchesParameters) {
            this.findMatchesParameters = findMatchesParameters;
            return this;
        }

        @Override
        public TransformParameters build() {
            return new TransformParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
