/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that references a schema stored in the Glue Schema Registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaReference implements SdkPojo, Serializable, ToCopyableBuilder<SchemaReference.Builder, SchemaReference> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.<SchemaId> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaId").getter(getter(SchemaReference::schemaId)).setter(setter(Builder::schemaId))
            .constructor(SchemaId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionId").getter(getter(SchemaReference::schemaVersionId))
            .setter(setter(Builder::schemaVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()).build();

    private static final SdkField<Long> SCHEMA_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SchemaVersionNumber").getter(getter(SchemaReference::schemaVersionNumber))
            .setter(setter(Builder::schemaVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD,
            SCHEMA_VERSION_ID_FIELD, SCHEMA_VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SchemaId schemaId;

    private final String schemaVersionId;

    private final Long schemaVersionNumber;

    private SchemaReference(BuilderImpl builder) {
        this.schemaId = builder.schemaId;
        this.schemaVersionId = builder.schemaVersionId;
        this.schemaVersionNumber = builder.schemaVersionNumber;
    }

    /**
     * <p>
     * A structure that contains schema identity fields. Either this or the <code>SchemaVersionId</code> has to be
     * provided.
     * </p>
     * 
     * @return A structure that contains schema identity fields. Either this or the <code>SchemaVersionId</code> has to
     *         be provided.
     */
    public final SchemaId schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The unique ID assigned to a version of the schema. Either this or the <code>SchemaId</code> has to be provided.
     * </p>
     * 
     * @return The unique ID assigned to a version of the schema. Either this or the <code>SchemaId</code> has to be
     *         provided.
     */
    public final String schemaVersionId() {
        return schemaVersionId;
    }

    /**
     * <p>
     * The version number of the schema.
     * </p>
     * 
     * @return The version number of the schema.
     */
    public final Long schemaVersionNumber() {
        return schemaVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaReference)) {
            return false;
        }
        SchemaReference other = (SchemaReference) obj;
        return Objects.equals(schemaId(), other.schemaId()) && Objects.equals(schemaVersionId(), other.schemaVersionId())
                && Objects.equals(schemaVersionNumber(), other.schemaVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaReference").add("SchemaId", schemaId()).add("SchemaVersionId", schemaVersionId())
                .add("SchemaVersionNumber", schemaVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "SchemaVersionId":
            return Optional.ofNullable(clazz.cast(schemaVersionId()));
        case "SchemaVersionNumber":
            return Optional.ofNullable(clazz.cast(schemaVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("SchemaVersionId", SCHEMA_VERSION_ID_FIELD);
        map.put("SchemaVersionNumber", SCHEMA_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaReference, T> g) {
        return obj -> g.apply((SchemaReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaReference> {
        /**
         * <p>
         * A structure that contains schema identity fields. Either this or the <code>SchemaVersionId</code> has to be
         * provided.
         * </p>
         * 
         * @param schemaId
         *        A structure that contains schema identity fields. Either this or the <code>SchemaVersionId</code> has
         *        to be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(SchemaId schemaId);

        /**
         * <p>
         * A structure that contains schema identity fields. Either this or the <code>SchemaVersionId</code> has to be
         * provided.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaId.Builder} avoiding the need to
         * create one manually via {@link SchemaId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaId.Builder#build()} is called immediately and its result is
         * passed to {@link #schemaId(SchemaId)}.
         * 
         * @param schemaId
         *        a consumer that will call methods on {@link SchemaId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaId(SchemaId)
         */
        default Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return schemaId(SchemaId.builder().applyMutation(schemaId).build());
        }

        /**
         * <p>
         * The unique ID assigned to a version of the schema. Either this or the <code>SchemaId</code> has to be
         * provided.
         * </p>
         * 
         * @param schemaVersionId
         *        The unique ID assigned to a version of the schema. Either this or the <code>SchemaId</code> has to be
         *        provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionId(String schemaVersionId);

        /**
         * <p>
         * The version number of the schema.
         * </p>
         * 
         * @param schemaVersionNumber
         *        The version number of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionNumber(Long schemaVersionNumber);
    }

    static final class BuilderImpl implements Builder {
        private SchemaId schemaId;

        private String schemaVersionId;

        private Long schemaVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaReference model) {
            schemaId(model.schemaId);
            schemaVersionId(model.schemaVersionId);
            schemaVersionNumber(model.schemaVersionNumber);
        }

        public final SchemaId.Builder getSchemaId() {
            return schemaId != null ? schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getSchemaVersionId() {
            return schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final Long getSchemaVersionNumber() {
            return schemaVersionNumber;
        }

        public final void setSchemaVersionNumber(Long schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
        }

        @Override
        public final Builder schemaVersionNumber(Long schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
            return this;
        }

        @Override
        public SchemaReference build() {
            return new SchemaReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
