/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies additional connection options for the Amazon S3 data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DirectSourceAdditionalOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DirectSourceAdditionalOptions.Builder, S3DirectSourceAdditionalOptions> {
    private static final SdkField<Long> BOUNDED_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BoundedSize").getter(getter(S3DirectSourceAdditionalOptions::boundedSize))
            .setter(setter(Builder::boundedSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundedSize").build()).build();

    private static final SdkField<Long> BOUNDED_FILES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BoundedFiles").getter(getter(S3DirectSourceAdditionalOptions::boundedFiles))
            .setter(setter(Builder::boundedFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundedFiles").build()).build();

    private static final SdkField<Boolean> ENABLE_SAMPLE_PATH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableSamplePath").getter(getter(S3DirectSourceAdditionalOptions::enableSamplePath))
            .setter(setter(Builder::enableSamplePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSamplePath").build()).build();

    private static final SdkField<String> SAMPLE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SamplePath").getter(getter(S3DirectSourceAdditionalOptions::samplePath))
            .setter(setter(Builder::samplePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDED_SIZE_FIELD,
            BOUNDED_FILES_FIELD, ENABLE_SAMPLE_PATH_FIELD, SAMPLE_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long boundedSize;

    private final Long boundedFiles;

    private final Boolean enableSamplePath;

    private final String samplePath;

    private S3DirectSourceAdditionalOptions(BuilderImpl builder) {
        this.boundedSize = builder.boundedSize;
        this.boundedFiles = builder.boundedFiles;
        this.enableSamplePath = builder.enableSamplePath;
        this.samplePath = builder.samplePath;
    }

    /**
     * <p>
     * Sets the upper limit for the target size of the dataset in bytes that will be processed.
     * </p>
     * 
     * @return Sets the upper limit for the target size of the dataset in bytes that will be processed.
     */
    public final Long boundedSize() {
        return boundedSize;
    }

    /**
     * <p>
     * Sets the upper limit for the target number of files that will be processed.
     * </p>
     * 
     * @return Sets the upper limit for the target number of files that will be processed.
     */
    public final Long boundedFiles() {
        return boundedFiles;
    }

    /**
     * <p>
     * Sets option to enable a sample path.
     * </p>
     * 
     * @return Sets option to enable a sample path.
     */
    public final Boolean enableSamplePath() {
        return enableSamplePath;
    }

    /**
     * <p>
     * If enabled, specifies the sample path.
     * </p>
     * 
     * @return If enabled, specifies the sample path.
     */
    public final String samplePath() {
        return samplePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boundedSize());
        hashCode = 31 * hashCode + Objects.hashCode(boundedFiles());
        hashCode = 31 * hashCode + Objects.hashCode(enableSamplePath());
        hashCode = 31 * hashCode + Objects.hashCode(samplePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DirectSourceAdditionalOptions)) {
            return false;
        }
        S3DirectSourceAdditionalOptions other = (S3DirectSourceAdditionalOptions) obj;
        return Objects.equals(boundedSize(), other.boundedSize()) && Objects.equals(boundedFiles(), other.boundedFiles())
                && Objects.equals(enableSamplePath(), other.enableSamplePath())
                && Objects.equals(samplePath(), other.samplePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DirectSourceAdditionalOptions").add("BoundedSize", boundedSize())
                .add("BoundedFiles", boundedFiles()).add("EnableSamplePath", enableSamplePath()).add("SamplePath", samplePath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundedSize":
            return Optional.ofNullable(clazz.cast(boundedSize()));
        case "BoundedFiles":
            return Optional.ofNullable(clazz.cast(boundedFiles()));
        case "EnableSamplePath":
            return Optional.ofNullable(clazz.cast(enableSamplePath()));
        case "SamplePath":
            return Optional.ofNullable(clazz.cast(samplePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BoundedSize", BOUNDED_SIZE_FIELD);
        map.put("BoundedFiles", BOUNDED_FILES_FIELD);
        map.put("EnableSamplePath", ENABLE_SAMPLE_PATH_FIELD);
        map.put("SamplePath", SAMPLE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3DirectSourceAdditionalOptions, T> g) {
        return obj -> g.apply((S3DirectSourceAdditionalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DirectSourceAdditionalOptions> {
        /**
         * <p>
         * Sets the upper limit for the target size of the dataset in bytes that will be processed.
         * </p>
         * 
         * @param boundedSize
         *        Sets the upper limit for the target size of the dataset in bytes that will be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundedSize(Long boundedSize);

        /**
         * <p>
         * Sets the upper limit for the target number of files that will be processed.
         * </p>
         * 
         * @param boundedFiles
         *        Sets the upper limit for the target number of files that will be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundedFiles(Long boundedFiles);

        /**
         * <p>
         * Sets option to enable a sample path.
         * </p>
         * 
         * @param enableSamplePath
         *        Sets option to enable a sample path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSamplePath(Boolean enableSamplePath);

        /**
         * <p>
         * If enabled, specifies the sample path.
         * </p>
         * 
         * @param samplePath
         *        If enabled, specifies the sample path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplePath(String samplePath);
    }

    static final class BuilderImpl implements Builder {
        private Long boundedSize;

        private Long boundedFiles;

        private Boolean enableSamplePath;

        private String samplePath;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DirectSourceAdditionalOptions model) {
            boundedSize(model.boundedSize);
            boundedFiles(model.boundedFiles);
            enableSamplePath(model.enableSamplePath);
            samplePath(model.samplePath);
        }

        public final Long getBoundedSize() {
            return boundedSize;
        }

        public final void setBoundedSize(Long boundedSize) {
            this.boundedSize = boundedSize;
        }

        @Override
        public final Builder boundedSize(Long boundedSize) {
            this.boundedSize = boundedSize;
            return this;
        }

        public final Long getBoundedFiles() {
            return boundedFiles;
        }

        public final void setBoundedFiles(Long boundedFiles) {
            this.boundedFiles = boundedFiles;
        }

        @Override
        public final Builder boundedFiles(Long boundedFiles) {
            this.boundedFiles = boundedFiles;
            return this;
        }

        public final Boolean getEnableSamplePath() {
            return enableSamplePath;
        }

        public final void setEnableSamplePath(Boolean enableSamplePath) {
            this.enableSamplePath = enableSamplePath;
        }

        @Override
        public final Builder enableSamplePath(Boolean enableSamplePath) {
            this.enableSamplePath = enableSamplePath;
            return this;
        }

        public final String getSamplePath() {
            return samplePath;
        }

        public final void setSamplePath(String samplePath) {
            this.samplePath = samplePath;
        }

        @Override
        public final Builder samplePath(String samplePath) {
            this.samplePath = samplePath;
            return this;
        }

        @Override
        public S3DirectSourceAdditionalOptions build() {
            return new S3DirectSourceAdditionalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
