/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataQualityRulesetResponse extends GlueResponse implements
        ToCopyableBuilder<GetDataQualityRulesetResponse.Builder, GetDataQualityRulesetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetDataQualityRulesetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetDataQualityRulesetResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RULESET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ruleset")
            .getter(getter(GetDataQualityRulesetResponse::ruleset)).setter(setter(Builder::ruleset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ruleset").build()).build();

    private static final SdkField<DataQualityTargetTable> TARGET_TABLE_FIELD = SdkField
            .<DataQualityTargetTable> builder(MarshallingType.SDK_POJO).memberName("TargetTable")
            .getter(getter(GetDataQualityRulesetResponse::targetTable)).setter(setter(Builder::targetTable))
            .constructor(DataQualityTargetTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()).build();

    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedOn").getter(getter(GetDataQualityRulesetResponse::createdOn)).setter(setter(Builder::createdOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedOn").getter(getter(GetDataQualityRulesetResponse::lastModifiedOn))
            .setter(setter(Builder::lastModifiedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()).build();

    private static final SdkField<String> RECOMMENDATION_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationRunId").getter(getter(GetDataQualityRulesetResponse::recommendationRunId))
            .setter(setter(Builder::recommendationRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationRunId").build())
            .build();

    private static final SdkField<String> DATA_QUALITY_SECURITY_CONFIGURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataQualitySecurityConfiguration")
            .getter(getter(GetDataQualityRulesetResponse::dataQualitySecurityConfiguration))
            .setter(setter(Builder::dataQualitySecurityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySecurityConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            RULESET_FIELD, TARGET_TABLE_FIELD, CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, RECOMMENDATION_RUN_ID_FIELD,
            DATA_QUALITY_SECURITY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String ruleset;

    private final DataQualityTargetTable targetTable;

    private final Instant createdOn;

    private final Instant lastModifiedOn;

    private final String recommendationRunId;

    private final String dataQualitySecurityConfiguration;

    private GetDataQualityRulesetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.ruleset = builder.ruleset;
        this.targetTable = builder.targetTable;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.recommendationRunId = builder.recommendationRunId;
        this.dataQualitySecurityConfiguration = builder.dataQualitySecurityConfiguration;
    }

    /**
     * <p>
     * The name of the ruleset.
     * </p>
     * 
     * @return The name of the ruleset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the ruleset.
     * </p>
     * 
     * @return A description of the ruleset.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A Data Quality Definition Language (DQDL) ruleset. For more information, see the Glue developer guide.
     * </p>
     * 
     * @return A Data Quality Definition Language (DQDL) ruleset. For more information, see the Glue developer guide.
     */
    public final String ruleset() {
        return ruleset;
    }

    /**
     * <p>
     * The name and database name of the target table.
     * </p>
     * 
     * @return The name and database name of the target table.
     */
    public final DataQualityTargetTable targetTable() {
        return targetTable;
    }

    /**
     * <p>
     * A timestamp. The time and date that this data quality ruleset was created.
     * </p>
     * 
     * @return A timestamp. The time and date that this data quality ruleset was created.
     */
    public final Instant createdOn() {
        return createdOn;
    }

    /**
     * <p>
     * A timestamp. The last point in time when this data quality ruleset was modified.
     * </p>
     * 
     * @return A timestamp. The last point in time when this data quality ruleset was modified.
     */
    public final Instant lastModifiedOn() {
        return lastModifiedOn;
    }

    /**
     * <p>
     * When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
     * </p>
     * 
     * @return When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
     */
    public final String recommendationRunId() {
        return recommendationRunId;
    }

    /**
     * <p>
     * The name of the security configuration created with the data quality encryption option.
     * </p>
     * 
     * @return The name of the security configuration created with the data quality encryption option.
     */
    public final String dataQualitySecurityConfiguration() {
        return dataQualitySecurityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ruleset());
        hashCode = 31 * hashCode + Objects.hashCode(targetTable());
        hashCode = 31 * hashCode + Objects.hashCode(createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationRunId());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualitySecurityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityRulesetResponse)) {
            return false;
        }
        GetDataQualityRulesetResponse other = (GetDataQualityRulesetResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(ruleset(), other.ruleset()) && Objects.equals(targetTable(), other.targetTable())
                && Objects.equals(createdOn(), other.createdOn()) && Objects.equals(lastModifiedOn(), other.lastModifiedOn())
                && Objects.equals(recommendationRunId(), other.recommendationRunId())
                && Objects.equals(dataQualitySecurityConfiguration(), other.dataQualitySecurityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataQualityRulesetResponse").add("Name", name()).add("Description", description())
                .add("Ruleset", ruleset()).add("TargetTable", targetTable()).add("CreatedOn", createdOn())
                .add("LastModifiedOn", lastModifiedOn()).add("RecommendationRunId", recommendationRunId())
                .add("DataQualitySecurityConfiguration", dataQualitySecurityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Ruleset":
            return Optional.ofNullable(clazz.cast(ruleset()));
        case "TargetTable":
            return Optional.ofNullable(clazz.cast(targetTable()));
        case "CreatedOn":
            return Optional.ofNullable(clazz.cast(createdOn()));
        case "LastModifiedOn":
            return Optional.ofNullable(clazz.cast(lastModifiedOn()));
        case "RecommendationRunId":
            return Optional.ofNullable(clazz.cast(recommendationRunId()));
        case "DataQualitySecurityConfiguration":
            return Optional.ofNullable(clazz.cast(dataQualitySecurityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Ruleset", RULESET_FIELD);
        map.put("TargetTable", TARGET_TABLE_FIELD);
        map.put("CreatedOn", CREATED_ON_FIELD);
        map.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
        map.put("RecommendationRunId", RECOMMENDATION_RUN_ID_FIELD);
        map.put("DataQualitySecurityConfiguration", DATA_QUALITY_SECURITY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityRulesetResponse, T> g) {
        return obj -> g.apply((GetDataQualityRulesetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataQualityRulesetResponse> {
        /**
         * <p>
         * The name of the ruleset.
         * </p>
         * 
         * @param name
         *        The name of the ruleset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the ruleset.
         * </p>
         * 
         * @param description
         *        A description of the ruleset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A Data Quality Definition Language (DQDL) ruleset. For more information, see the Glue developer guide.
         * </p>
         * 
         * @param ruleset
         *        A Data Quality Definition Language (DQDL) ruleset. For more information, see the Glue developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleset(String ruleset);

        /**
         * <p>
         * The name and database name of the target table.
         * </p>
         * 
         * @param targetTable
         *        The name and database name of the target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTable(DataQualityTargetTable targetTable);

        /**
         * <p>
         * The name and database name of the target table.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQualityTargetTable.Builder} avoiding
         * the need to create one manually via {@link DataQualityTargetTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualityTargetTable.Builder#build()} is called immediately and
         * its result is passed to {@link #targetTable(DataQualityTargetTable)}.
         * 
         * @param targetTable
         *        a consumer that will call methods on {@link DataQualityTargetTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTable(DataQualityTargetTable)
         */
        default Builder targetTable(Consumer<DataQualityTargetTable.Builder> targetTable) {
            return targetTable(DataQualityTargetTable.builder().applyMutation(targetTable).build());
        }

        /**
         * <p>
         * A timestamp. The time and date that this data quality ruleset was created.
         * </p>
         * 
         * @param createdOn
         *        A timestamp. The time and date that this data quality ruleset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdOn(Instant createdOn);

        /**
         * <p>
         * A timestamp. The last point in time when this data quality ruleset was modified.
         * </p>
         * 
         * @param lastModifiedOn
         *        A timestamp. The last point in time when this data quality ruleset was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedOn(Instant lastModifiedOn);

        /**
         * <p>
         * When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
         * </p>
         * 
         * @param recommendationRunId
         *        When a ruleset was created from a recommendation run, this run ID is generated to link the two
         *        together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationRunId(String recommendationRunId);

        /**
         * <p>
         * The name of the security configuration created with the data quality encryption option.
         * </p>
         * 
         * @param dataQualitySecurityConfiguration
         *        The name of the security configuration created with the data quality encryption option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String ruleset;

        private DataQualityTargetTable targetTable;

        private Instant createdOn;

        private Instant lastModifiedOn;

        private String recommendationRunId;

        private String dataQualitySecurityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityRulesetResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            ruleset(model.ruleset);
            targetTable(model.targetTable);
            createdOn(model.createdOn);
            lastModifiedOn(model.lastModifiedOn);
            recommendationRunId(model.recommendationRunId);
            dataQualitySecurityConfiguration(model.dataQualitySecurityConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleset() {
            return ruleset;
        }

        public final void setRuleset(String ruleset) {
            this.ruleset = ruleset;
        }

        @Override
        public final Builder ruleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public final DataQualityTargetTable.Builder getTargetTable() {
            return targetTable != null ? targetTable.toBuilder() : null;
        }

        public final void setTargetTable(DataQualityTargetTable.BuilderImpl targetTable) {
            this.targetTable = targetTable != null ? targetTable.build() : null;
        }

        @Override
        public final Builder targetTable(DataQualityTargetTable targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public final Instant getCreatedOn() {
            return createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final String getRecommendationRunId() {
            return recommendationRunId;
        }

        public final void setRecommendationRunId(String recommendationRunId) {
            this.recommendationRunId = recommendationRunId;
        }

        @Override
        public final Builder recommendationRunId(String recommendationRunId) {
            this.recommendationRunId = recommendationRunId;
            return this;
        }

        public final String getDataQualitySecurityConfiguration() {
            return dataQualitySecurityConfiguration;
        }

        public final void setDataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
        }

        @Override
        public final Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
            return this;
        }

        @Override
        public GetDataQualityRulesetResponse build() {
            return new GetDataQualityRulesetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
