/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataQualityRuleRecommendationRunResponse extends GlueResponse implements
        ToCopyableBuilder<GetDataQualityRuleRecommendationRunResponse.Builder, GetDataQualityRuleRecommendationRunResponse> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(GetDataQualityRuleRecommendationRunResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(GetDataQualityRuleRecommendationRunResponse::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(GetDataQualityRuleRecommendationRunResponse::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(GetDataQualityRuleRecommendationRunResponse::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(GetDataQualityRuleRecommendationRunResponse::timeout))
            .setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDataQualityRuleRecommendationRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorString").getter(getter(GetDataQualityRuleRecommendationRunResponse::errorString))
            .setter(setter(Builder::errorString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorString").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(GetDataQualityRuleRecommendationRunResponse::startedOn))
            .setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedOn").getter(getter(GetDataQualityRuleRecommendationRunResponse::lastModifiedOn))
            .setter(setter(Builder::lastModifiedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()).build();

    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedOn").getter(getter(GetDataQualityRuleRecommendationRunResponse::completedOn))
            .setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionTime").getter(getter(GetDataQualityRuleRecommendationRunResponse::executionTime))
            .setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()).build();

    private static final SdkField<String> RECOMMENDED_RULESET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendedRuleset").getter(getter(GetDataQualityRuleRecommendationRunResponse::recommendedRuleset))
            .setter(setter(Builder::recommendedRuleset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedRuleset").build())
            .build();

    private static final SdkField<String> CREATED_RULESET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedRulesetName").getter(getter(GetDataQualityRuleRecommendationRunResponse::createdRulesetName))
            .setter(setter(Builder::createdRulesetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedRulesetName").build())
            .build();

    private static final SdkField<String> DATA_QUALITY_SECURITY_CONFIGURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataQualitySecurityConfiguration")
            .getter(getter(GetDataQualityRuleRecommendationRunResponse::dataQualitySecurityConfiguration))
            .setter(setter(Builder::dataQualitySecurityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySecurityConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD,
            DATA_SOURCE_FIELD, ROLE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, STATUS_FIELD, ERROR_STRING_FIELD,
            STARTED_ON_FIELD, LAST_MODIFIED_ON_FIELD, COMPLETED_ON_FIELD, EXECUTION_TIME_FIELD, RECOMMENDED_RULESET_FIELD,
            CREATED_RULESET_NAME_FIELD, DATA_QUALITY_SECURITY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String runId;

    private final DataSource dataSource;

    private final String role;

    private final Integer numberOfWorkers;

    private final Integer timeout;

    private final String status;

    private final String errorString;

    private final Instant startedOn;

    private final Instant lastModifiedOn;

    private final Instant completedOn;

    private final Integer executionTime;

    private final String recommendedRuleset;

    private final String createdRulesetName;

    private final String dataQualitySecurityConfiguration;

    private GetDataQualityRuleRecommendationRunResponse(BuilderImpl builder) {
        super(builder);
        this.runId = builder.runId;
        this.dataSource = builder.dataSource;
        this.role = builder.role;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.status = builder.status;
        this.errorString = builder.errorString;
        this.startedOn = builder.startedOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.completedOn = builder.completedOn;
        this.executionTime = builder.executionTime;
        this.recommendedRuleset = builder.recommendedRuleset;
        this.createdRulesetName = builder.createdRulesetName;
        this.dataQualitySecurityConfiguration = builder.dataQualitySecurityConfiguration;
    }

    /**
     * <p>
     * The unique run identifier associated with this run.
     * </p>
     * 
     * @return The unique run identifier associated with this run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The data source (an Glue table) associated with this run.
     * </p>
     * 
     * @return The data source (an Glue table) associated with this run.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * An IAM role supplied to encrypt the results of the run.
     * </p>
     * 
     * @return An IAM role supplied to encrypt the results of the run.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The number of <code>G.1X</code> workers to be used in the run. The default is 5.
     * </p>
     * 
     * @return The number of <code>G.1X</code> workers to be used in the run. The default is 5.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
     * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     * </p>
     * 
     * @return The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
     *         terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The status for this run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for this run.
     * @see TaskStatusType
     */
    public final TaskStatusType status() {
        return TaskStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status for this run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for this run.
     * @see TaskStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error strings that are associated with the run.
     * </p>
     * 
     * @return The error strings that are associated with the run.
     */
    public final String errorString() {
        return errorString;
    }

    /**
     * <p>
     * The date and time when this run started.
     * </p>
     * 
     * @return The date and time when this run started.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * A timestamp. The last point in time when this data quality rule recommendation run was modified.
     * </p>
     * 
     * @return A timestamp. The last point in time when this data quality rule recommendation run was modified.
     */
    public final Instant lastModifiedOn() {
        return lastModifiedOn;
    }

    /**
     * <p>
     * The date and time when this run was completed.
     * </p>
     * 
     * @return The date and time when this run was completed.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * <p>
     * The amount of time (in seconds) that the run consumed resources.
     * </p>
     * 
     * @return The amount of time (in seconds) that the run consumed resources.
     */
    public final Integer executionTime() {
        return executionTime;
    }

    /**
     * <p>
     * When a start rule recommendation run completes, it creates a recommended ruleset (a set of rules). This member
     * has those rules in Data Quality Definition Language (DQDL) format.
     * </p>
     * 
     * @return When a start rule recommendation run completes, it creates a recommended ruleset (a set of rules). This
     *         member has those rules in Data Quality Definition Language (DQDL) format.
     */
    public final String recommendedRuleset() {
        return recommendedRuleset;
    }

    /**
     * <p>
     * The name of the ruleset that was created by the run.
     * </p>
     * 
     * @return The name of the ruleset that was created by the run.
     */
    public final String createdRulesetName() {
        return createdRulesetName;
    }

    /**
     * <p>
     * The name of the security configuration created with the data quality encryption option.
     * </p>
     * 
     * @return The name of the security configuration created with the data quality encryption option.
     */
    public final String dataQualitySecurityConfiguration() {
        return dataQualitySecurityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorString());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedRuleset());
        hashCode = 31 * hashCode + Objects.hashCode(createdRulesetName());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualitySecurityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityRuleRecommendationRunResponse)) {
            return false;
        }
        GetDataQualityRuleRecommendationRunResponse other = (GetDataQualityRuleRecommendationRunResponse) obj;
        return Objects.equals(runId(), other.runId()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(role(), other.role()) && Objects.equals(numberOfWorkers(), other.numberOfWorkers())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorString(), other.errorString()) && Objects.equals(startedOn(), other.startedOn())
                && Objects.equals(lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(completedOn(), other.completedOn())
                && Objects.equals(executionTime(), other.executionTime())
                && Objects.equals(recommendedRuleset(), other.recommendedRuleset())
                && Objects.equals(createdRulesetName(), other.createdRulesetName())
                && Objects.equals(dataQualitySecurityConfiguration(), other.dataQualitySecurityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataQualityRuleRecommendationRunResponse").add("RunId", runId())
                .add("DataSource", dataSource()).add("Role", role()).add("NumberOfWorkers", numberOfWorkers())
                .add("Timeout", timeout()).add("Status", statusAsString()).add("ErrorString", errorString())
                .add("StartedOn", startedOn()).add("LastModifiedOn", lastModifiedOn()).add("CompletedOn", completedOn())
                .add("ExecutionTime", executionTime()).add("RecommendedRuleset", recommendedRuleset())
                .add("CreatedRulesetName", createdRulesetName())
                .add("DataQualitySecurityConfiguration", dataQualitySecurityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorString":
            return Optional.ofNullable(clazz.cast(errorString()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "LastModifiedOn":
            return Optional.ofNullable(clazz.cast(lastModifiedOn()));
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "ExecutionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        case "RecommendedRuleset":
            return Optional.ofNullable(clazz.cast(recommendedRuleset()));
        case "CreatedRulesetName":
            return Optional.ofNullable(clazz.cast(createdRulesetName()));
        case "DataQualitySecurityConfiguration":
            return Optional.ofNullable(clazz.cast(dataQualitySecurityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RunId", RUN_ID_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
        map.put("Timeout", TIMEOUT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorString", ERROR_STRING_FIELD);
        map.put("StartedOn", STARTED_ON_FIELD);
        map.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
        map.put("CompletedOn", COMPLETED_ON_FIELD);
        map.put("ExecutionTime", EXECUTION_TIME_FIELD);
        map.put("RecommendedRuleset", RECOMMENDED_RULESET_FIELD);
        map.put("CreatedRulesetName", CREATED_RULESET_NAME_FIELD);
        map.put("DataQualitySecurityConfiguration", DATA_QUALITY_SECURITY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityRuleRecommendationRunResponse, T> g) {
        return obj -> g.apply((GetDataQualityRuleRecommendationRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataQualityRuleRecommendationRunResponse> {
        /**
         * <p>
         * The unique run identifier associated with this run.
         * </p>
         * 
         * @param runId
         *        The unique run identifier associated with this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The data source (an Glue table) associated with this run.
         * </p>
         * 
         * @param dataSource
         *        The data source (an Glue table) associated with this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The data source (an Glue table) associated with this run.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * An IAM role supplied to encrypt the results of the run.
         * </p>
         * 
         * @param role
         *        An IAM role supplied to encrypt the results of the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The number of <code>G.1X</code> workers to be used in the run. The default is 5.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of <code>G.1X</code> workers to be used in the run. The default is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
         * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * </p>
         * 
         * @param timeout
         *        The timeout for a run in minutes. This is the maximum time that a run can consume resources before it
         *        is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The status for this run.
         * </p>
         * 
         * @param status
         *        The status for this run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status for this run.
         * </p>
         * 
         * @param status
         *        The status for this run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(TaskStatusType status);

        /**
         * <p>
         * The error strings that are associated with the run.
         * </p>
         * 
         * @param errorString
         *        The error strings that are associated with the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorString(String errorString);

        /**
         * <p>
         * The date and time when this run started.
         * </p>
         * 
         * @param startedOn
         *        The date and time when this run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * A timestamp. The last point in time when this data quality rule recommendation run was modified.
         * </p>
         * 
         * @param lastModifiedOn
         *        A timestamp. The last point in time when this data quality rule recommendation run was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedOn(Instant lastModifiedOn);

        /**
         * <p>
         * The date and time when this run was completed.
         * </p>
         * 
         * @param completedOn
         *        The date and time when this run was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * The amount of time (in seconds) that the run consumed resources.
         * </p>
         * 
         * @param executionTime
         *        The amount of time (in seconds) that the run consumed resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Integer executionTime);

        /**
         * <p>
         * When a start rule recommendation run completes, it creates a recommended ruleset (a set of rules). This
         * member has those rules in Data Quality Definition Language (DQDL) format.
         * </p>
         * 
         * @param recommendedRuleset
         *        When a start rule recommendation run completes, it creates a recommended ruleset (a set of rules).
         *        This member has those rules in Data Quality Definition Language (DQDL) format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedRuleset(String recommendedRuleset);

        /**
         * <p>
         * The name of the ruleset that was created by the run.
         * </p>
         * 
         * @param createdRulesetName
         *        The name of the ruleset that was created by the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRulesetName(String createdRulesetName);

        /**
         * <p>
         * The name of the security configuration created with the data quality encryption option.
         * </p>
         * 
         * @param dataQualitySecurityConfiguration
         *        The name of the security configuration created with the data quality encryption option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String runId;

        private DataSource dataSource;

        private String role;

        private Integer numberOfWorkers;

        private Integer timeout;

        private String status;

        private String errorString;

        private Instant startedOn;

        private Instant lastModifiedOn;

        private Instant completedOn;

        private Integer executionTime;

        private String recommendedRuleset;

        private String createdRulesetName;

        private String dataQualitySecurityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityRuleRecommendationRunResponse model) {
            super(model);
            runId(model.runId);
            dataSource(model.dataSource);
            role(model.role);
            numberOfWorkers(model.numberOfWorkers);
            timeout(model.timeout);
            status(model.status);
            errorString(model.errorString);
            startedOn(model.startedOn);
            lastModifiedOn(model.lastModifiedOn);
            completedOn(model.completedOn);
            executionTime(model.executionTime);
            recommendedRuleset(model.recommendedRuleset);
            createdRulesetName(model.createdRulesetName);
            dataQualitySecurityConfiguration(model.dataQualitySecurityConfiguration);
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorString() {
            return errorString;
        }

        public final void setErrorString(String errorString) {
            this.errorString = errorString;
        }

        @Override
        public final Builder errorString(String errorString) {
            this.errorString = errorString;
            return this;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final Integer getExecutionTime() {
            return executionTime;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final String getRecommendedRuleset() {
            return recommendedRuleset;
        }

        public final void setRecommendedRuleset(String recommendedRuleset) {
            this.recommendedRuleset = recommendedRuleset;
        }

        @Override
        public final Builder recommendedRuleset(String recommendedRuleset) {
            this.recommendedRuleset = recommendedRuleset;
            return this;
        }

        public final String getCreatedRulesetName() {
            return createdRulesetName;
        }

        public final void setCreatedRulesetName(String createdRulesetName) {
            this.createdRulesetName = createdRulesetName;
        }

        @Override
        public final Builder createdRulesetName(String createdRulesetName) {
            this.createdRulesetName = createdRulesetName;
            return this;
        }

        public final String getDataQualitySecurityConfiguration() {
            return dataQualitySecurityConfiguration;
        }

        public final void setDataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
        }

        @Override
        public final Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
            return this;
        }

        @Override
        public GetDataQualityRuleRecommendationRunResponse build() {
            return new GetDataQualityRuleRecommendationRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
