/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckSchemaVersionValidityRequest extends GlueRequest implements
        ToCopyableBuilder<CheckSchemaVersionValidityRequest.Builder, CheckSchemaVersionValidityRequest> {
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(CheckSchemaVersionValidityRequest::dataFormatAsString))
            .setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> SCHEMA_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaDefinition").getter(getter(CheckSchemaVersionValidityRequest::schemaDefinition))
            .setter(setter(Builder::schemaDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FORMAT_FIELD,
            SCHEMA_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataFormat;

    private final String schemaDefinition;

    private CheckSchemaVersionValidityRequest(BuilderImpl builder) {
        super(builder);
        this.dataFormat = builder.dataFormat;
        this.schemaDefinition = builder.schemaDefinition;
    }

    /**
     * <p>
     * The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
     * <code>PROTOBUF</code> are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
     *         <code>PROTOBUF</code> are supported.
     * @see DataFormat
     */
    public final DataFormat dataFormat() {
        return DataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
     * <code>PROTOBUF</code> are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
     *         <code>PROTOBUF</code> are supported.
     * @see DataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The definition of the schema that has to be validated.
     * </p>
     * 
     * @return The definition of the schema that has to be validated.
     */
    public final String schemaDefinition() {
        return schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckSchemaVersionValidityRequest)) {
            return false;
        }
        CheckSchemaVersionValidityRequest other = (CheckSchemaVersionValidityRequest) obj;
        return Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(schemaDefinition(), other.schemaDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckSchemaVersionValidityRequest").add("DataFormat", dataFormatAsString())
                .add("SchemaDefinition", schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "SchemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataFormat", DATA_FORMAT_FIELD);
        map.put("SchemaDefinition", SCHEMA_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckSchemaVersionValidityRequest, T> g) {
        return obj -> g.apply((CheckSchemaVersionValidityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CheckSchemaVersionValidityRequest> {
        /**
         * <p>
         * The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
         * <code>PROTOBUF</code> are supported.
         * </p>
         * 
         * @param dataFormat
         *        The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
         *        <code>PROTOBUF</code> are supported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
         * <code>PROTOBUF</code> are supported.
         * </p>
         * 
         * @param dataFormat
         *        The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
         *        <code>PROTOBUF</code> are supported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(DataFormat dataFormat);

        /**
         * <p>
         * The definition of the schema that has to be validated.
         * </p>
         * 
         * @param schemaDefinition
         *        The definition of the schema that has to be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(String schemaDefinition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String dataFormat;

        private String schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckSchemaVersionValidityRequest model) {
            super(model);
            dataFormat(model.dataFormat);
            schemaDefinition(model.schemaDefinition);
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getSchemaDefinition() {
            return schemaDefinition;
        }

        public final void setSchemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public final Builder schemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckSchemaVersionValidityRequest build() {
            return new CheckSchemaVersionValidityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
