/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse;

public class ListCustomRoutingPortMappingsByDestinationPublisher
implements SdkPublisher<ListCustomRoutingPortMappingsByDestinationResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListCustomRoutingPortMappingsByDestinationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomRoutingPortMappingsByDestinationPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingPortMappingsByDestinationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomRoutingPortMappingsByDestinationPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingPortMappingsByDestinationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomRoutingPortMappingsByDestinationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomRoutingPortMappingsByDestinationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DestinationPortMapping> destinationPortMappings() {
        Function<ListCustomRoutingPortMappingsByDestinationResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinationPortMappings() != null) {
                return response.destinationPortMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomRoutingPortMappingsByDestinationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomRoutingPortMappingsByDestinationResponseFetcher
    implements AsyncPageFetcher<ListCustomRoutingPortMappingsByDestinationResponse> {
        private ListCustomRoutingPortMappingsByDestinationResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingPortMappingsByDestinationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomRoutingPortMappingsByDestinationResponse> nextPage(ListCustomRoutingPortMappingsByDestinationResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingPortMappingsByDestinationPublisher.this.client.listCustomRoutingPortMappingsByDestination(ListCustomRoutingPortMappingsByDestinationPublisher.this.firstRequest);
            }
            return ListCustomRoutingPortMappingsByDestinationPublisher.this.client.listCustomRoutingPortMappingsByDestination((ListCustomRoutingPortMappingsByDestinationRequest)((Object)ListCustomRoutingPortMappingsByDestinationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

