/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.BatchImport;
import software.amazon.awssdk.services.frauddetector.model.BatchImportListCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBatchImportJobsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetBatchImportJobsResponse> {
    private static final SdkField<List<BatchImport>> BATCH_IMPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("batchImports").getter(GetBatchImportJobsResponse.getter(GetBatchImportJobsResponse::batchImports)).setter(GetBatchImportJobsResponse.setter(Builder::batchImports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchImports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchImport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetBatchImportJobsResponse.getter(GetBatchImportJobsResponse::nextToken)).setter(GetBatchImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_IMPORTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBatchImportJobsResponse.memberNameToFieldInitializer();
    private final List<BatchImport> batchImports;
    private final String nextToken;

    private GetBatchImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.batchImports = builder.batchImports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBatchImports() {
        return this.batchImports != null && !(this.batchImports instanceof SdkAutoConstructList);
    }

    public final List<BatchImport> batchImports() {
        return this.batchImports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchImports() ? this.batchImports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBatchImportJobsResponse)) {
            return false;
        }
        GetBatchImportJobsResponse other = (GetBatchImportJobsResponse)((Object)obj);
        return this.hasBatchImports() == other.hasBatchImports() && Objects.equals(this.batchImports(), other.batchImports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetBatchImportJobsResponse").add("BatchImports", this.hasBatchImports() ? this.batchImports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batchImports": {
                return Optional.ofNullable(clazz.cast(this.batchImports()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("batchImports", BATCH_IMPORTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBatchImportJobsResponse, T> g) {
        return obj -> g.apply((GetBatchImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<BatchImport> batchImports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBatchImportJobsResponse model) {
            super(model);
            this.batchImports(model.batchImports);
            this.nextToken(model.nextToken);
        }

        public final List<BatchImport.Builder> getBatchImports() {
            List<BatchImport.Builder> result = BatchImportListCopier.copyToBuilder(this.batchImports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchImports(Collection<BatchImport.BuilderImpl> batchImports) {
            this.batchImports = BatchImportListCopier.copyFromBuilder(batchImports);
        }

        @Override
        public final Builder batchImports(Collection<BatchImport> batchImports) {
            this.batchImports = BatchImportListCopier.copy(batchImports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchImports(BatchImport ... batchImports) {
            this.batchImports(Arrays.asList(batchImports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchImports(Consumer<BatchImport.Builder> ... batchImports) {
            this.batchImports(Stream.of(batchImports).map(c -> (BatchImport)((BatchImport.Builder)BatchImport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetBatchImportJobsResponse build() {
            return new GetBatchImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBatchImportJobsResponse> {
        public Builder batchImports(Collection<BatchImport> var1);

        public Builder batchImports(BatchImport ... var1);

        public Builder batchImports(Consumer<BatchImport.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

