/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse;

public class ListEventPredictionsPublisher
implements SdkPublisher<ListEventPredictionsResponse> {
    private final FraudDetectorAsyncClient client;
    private final ListEventPredictionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventPredictionsPublisher(FraudDetectorAsyncClient client, ListEventPredictionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventPredictionsPublisher(FraudDetectorAsyncClient client, ListEventPredictionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventPredictionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventPredictionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEventPredictionsResponseFetcher
    implements AsyncPageFetcher<ListEventPredictionsResponse> {
        private ListEventPredictionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventPredictionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventPredictionsResponse> nextPage(ListEventPredictionsResponse previousPage) {
            if (previousPage == null) {
                return ListEventPredictionsPublisher.this.client.listEventPredictions(ListEventPredictionsPublisher.this.firstRequest);
            }
            return ListEventPredictionsPublisher.this.client.listEventPredictions((ListEventPredictionsRequest)((Object)ListEventPredictionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

