/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ATIMetricDataPoint;
import software.amazon.awssdk.services.frauddetector.model.ATIMetricDataPointsListCopier;
import software.amazon.awssdk.services.frauddetector.model.ATIModelPerformance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ATITrainingMetricsValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ATITrainingMetricsValue> {
    private static final SdkField<List<ATIMetricDataPoint>> METRIC_DATA_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricDataPoints").getter(ATITrainingMetricsValue.getter(ATITrainingMetricsValue::metricDataPoints)).setter(ATITrainingMetricsValue.setter(Builder::metricDataPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDataPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ATIMetricDataPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ATIModelPerformance> MODEL_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelPerformance").getter(ATITrainingMetricsValue.getter(ATITrainingMetricsValue::modelPerformance)).setter(ATITrainingMetricsValue.setter(Builder::modelPerformance)).constructor(ATIModelPerformance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelPerformance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_POINTS_FIELD, MODEL_PERFORMANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("metricDataPoints", METRIC_DATA_POINTS_FIELD);
            this.put("modelPerformance", MODEL_PERFORMANCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ATIMetricDataPoint> metricDataPoints;
    private final ATIModelPerformance modelPerformance;

    private ATITrainingMetricsValue(BuilderImpl builder) {
        this.metricDataPoints = builder.metricDataPoints;
        this.modelPerformance = builder.modelPerformance;
    }

    public final boolean hasMetricDataPoints() {
        return this.metricDataPoints != null && !(this.metricDataPoints instanceof SdkAutoConstructList);
    }

    public final List<ATIMetricDataPoint> metricDataPoints() {
        return this.metricDataPoints;
    }

    public final ATIModelPerformance modelPerformance() {
        return this.modelPerformance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDataPoints() ? this.metricDataPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPerformance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ATITrainingMetricsValue)) {
            return false;
        }
        ATITrainingMetricsValue other = (ATITrainingMetricsValue)obj;
        return this.hasMetricDataPoints() == other.hasMetricDataPoints() && Objects.equals(this.metricDataPoints(), other.metricDataPoints()) && Objects.equals(this.modelPerformance(), other.modelPerformance());
    }

    public final String toString() {
        return ToString.builder((String)"ATITrainingMetricsValue").add("MetricDataPoints", this.hasMetricDataPoints() ? this.metricDataPoints() : null).add("ModelPerformance", (Object)this.modelPerformance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricDataPoints": {
                return Optional.ofNullable(clazz.cast(this.metricDataPoints()));
            }
            case "modelPerformance": {
                return Optional.ofNullable(clazz.cast(this.modelPerformance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ATITrainingMetricsValue, T> g) {
        return obj -> g.apply((ATITrainingMetricsValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ATIMetricDataPoint> metricDataPoints = DefaultSdkAutoConstructList.getInstance();
        private ATIModelPerformance modelPerformance;

        private BuilderImpl() {
        }

        private BuilderImpl(ATITrainingMetricsValue model) {
            this.metricDataPoints(model.metricDataPoints);
            this.modelPerformance(model.modelPerformance);
        }

        public final List<ATIMetricDataPoint.Builder> getMetricDataPoints() {
            List<ATIMetricDataPoint.Builder> result = ATIMetricDataPointsListCopier.copyToBuilder(this.metricDataPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataPoints(Collection<ATIMetricDataPoint.BuilderImpl> metricDataPoints) {
            this.metricDataPoints = ATIMetricDataPointsListCopier.copyFromBuilder(metricDataPoints);
        }

        @Override
        public final Builder metricDataPoints(Collection<ATIMetricDataPoint> metricDataPoints) {
            this.metricDataPoints = ATIMetricDataPointsListCopier.copy(metricDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(ATIMetricDataPoint ... metricDataPoints) {
            this.metricDataPoints(Arrays.asList(metricDataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(Consumer<ATIMetricDataPoint.Builder> ... metricDataPoints) {
            this.metricDataPoints(Stream.of(metricDataPoints).map(c -> (ATIMetricDataPoint)((ATIMetricDataPoint.Builder)ATIMetricDataPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ATIModelPerformance.Builder getModelPerformance() {
            return this.modelPerformance != null ? this.modelPerformance.toBuilder() : null;
        }

        public final void setModelPerformance(ATIModelPerformance.BuilderImpl modelPerformance) {
            this.modelPerformance = modelPerformance != null ? modelPerformance.build() : null;
        }

        @Override
        public final Builder modelPerformance(ATIModelPerformance modelPerformance) {
            this.modelPerformance = modelPerformance;
            return this;
        }

        public ATITrainingMetricsValue build() {
            return new ATITrainingMetricsValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ATITrainingMetricsValue> {
        public Builder metricDataPoints(Collection<ATIMetricDataPoint> var1);

        public Builder metricDataPoints(ATIMetricDataPoint ... var1);

        public Builder metricDataPoints(Consumer<ATIMetricDataPoint.Builder> ... var1);

        public Builder modelPerformance(ATIModelPerformance var1);

        default public Builder modelPerformance(Consumer<ATIModelPerformance.Builder> modelPerformance) {
            return this.modelPerformance((ATIModelPerformance)((ATIModelPerformance.Builder)ATIModelPerformance.builder().applyMutation(modelPerformance)).build());
        }
    }
}

