/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OFIMetricDataPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OFIMetricDataPoint> {
    private static final SdkField<Float> FPR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("fpr").getter(OFIMetricDataPoint.getter(OFIMetricDataPoint::fpr)).setter(OFIMetricDataPoint.setter(Builder::fpr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fpr").build()}).build();
    private static final SdkField<Float> PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("precision").getter(OFIMetricDataPoint.getter(OFIMetricDataPoint::precision)).setter(OFIMetricDataPoint.setter(Builder::precision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("precision").build()}).build();
    private static final SdkField<Float> TPR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("tpr").getter(OFIMetricDataPoint.getter(OFIMetricDataPoint::tpr)).setter(OFIMetricDataPoint.setter(Builder::tpr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tpr").build()}).build();
    private static final SdkField<Float> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("threshold").getter(OFIMetricDataPoint.getter(OFIMetricDataPoint::threshold)).setter(OFIMetricDataPoint.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPR_FIELD, PRECISION_FIELD, TPR_FIELD, THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fpr", FPR_FIELD);
            this.put("precision", PRECISION_FIELD);
            this.put("tpr", TPR_FIELD);
            this.put("threshold", THRESHOLD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Float fpr;
    private final Float precision;
    private final Float tpr;
    private final Float threshold;

    private OFIMetricDataPoint(BuilderImpl builder) {
        this.fpr = builder.fpr;
        this.precision = builder.precision;
        this.tpr = builder.tpr;
        this.threshold = builder.threshold;
    }

    public final Float fpr() {
        return this.fpr;
    }

    public final Float precision() {
        return this.precision;
    }

    public final Float tpr() {
        return this.tpr;
    }

    public final Float threshold() {
        return this.threshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpr());
        hashCode = 31 * hashCode + Objects.hashCode(this.precision());
        hashCode = 31 * hashCode + Objects.hashCode(this.tpr());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFIMetricDataPoint)) {
            return false;
        }
        OFIMetricDataPoint other = (OFIMetricDataPoint)obj;
        return Objects.equals(this.fpr(), other.fpr()) && Objects.equals(this.precision(), other.precision()) && Objects.equals(this.tpr(), other.tpr()) && Objects.equals(this.threshold(), other.threshold());
    }

    public final String toString() {
        return ToString.builder((String)"OFIMetricDataPoint").add("Fpr", (Object)this.fpr()).add("Precision", (Object)this.precision()).add("Tpr", (Object)this.tpr()).add("Threshold", (Object)this.threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fpr": {
                return Optional.ofNullable(clazz.cast(this.fpr()));
            }
            case "precision": {
                return Optional.ofNullable(clazz.cast(this.precision()));
            }
            case "tpr": {
                return Optional.ofNullable(clazz.cast(this.tpr()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OFIMetricDataPoint, T> g) {
        return obj -> g.apply((OFIMetricDataPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float fpr;
        private Float precision;
        private Float tpr;
        private Float threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(OFIMetricDataPoint model) {
            this.fpr(model.fpr);
            this.precision(model.precision);
            this.tpr(model.tpr);
            this.threshold(model.threshold);
        }

        public final Float getFpr() {
            return this.fpr;
        }

        public final void setFpr(Float fpr) {
            this.fpr = fpr;
        }

        @Override
        public final Builder fpr(Float fpr) {
            this.fpr = fpr;
            return this;
        }

        public final Float getPrecision() {
            return this.precision;
        }

        public final void setPrecision(Float precision) {
            this.precision = precision;
        }

        @Override
        public final Builder precision(Float precision) {
            this.precision = precision;
            return this;
        }

        public final Float getTpr() {
            return this.tpr;
        }

        public final void setTpr(Float tpr) {
            this.tpr = tpr;
        }

        @Override
        public final Builder tpr(Float tpr) {
            this.tpr = tpr;
            return this;
        }

        public final Float getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Float threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Float threshold) {
            this.threshold = threshold;
            return this;
        }

        public OFIMetricDataPoint build() {
            return new OFIMetricDataPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OFIMetricDataPoint> {
        public Builder fpr(Float var1);

        public Builder precision(Float var1);

        public Builder tpr(Float var1);

        public Builder threshold(Float var1);
    }
}

