/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregatedLogOddsMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregatedLogOddsMetric> {
    private static final SdkField<List<String>> VARIABLE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variableNames").getter(AggregatedLogOddsMetric.getter(AggregatedLogOddsMetric::variableNames)).setter(AggregatedLogOddsMetric.setter(Builder::variableNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> AGGREGATED_VARIABLES_IMPORTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("aggregatedVariablesImportance").getter(AggregatedLogOddsMetric.getter(AggregatedLogOddsMetric::aggregatedVariablesImportance)).setter(AggregatedLogOddsMetric.setter(Builder::aggregatedVariablesImportance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedVariablesImportance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_NAMES_FIELD, AGGREGATED_VARIABLES_IMPORTANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("variableNames", VARIABLE_NAMES_FIELD);
            this.put("aggregatedVariablesImportance", AGGREGATED_VARIABLES_IMPORTANCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> variableNames;
    private final Float aggregatedVariablesImportance;

    private AggregatedLogOddsMetric(BuilderImpl builder) {
        this.variableNames = builder.variableNames;
        this.aggregatedVariablesImportance = builder.aggregatedVariablesImportance;
    }

    public final boolean hasVariableNames() {
        return this.variableNames != null && !(this.variableNames instanceof SdkAutoConstructList);
    }

    public final List<String> variableNames() {
        return this.variableNames;
    }

    public final Float aggregatedVariablesImportance() {
        return this.aggregatedVariablesImportance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariableNames() ? this.variableNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedVariablesImportance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedLogOddsMetric)) {
            return false;
        }
        AggregatedLogOddsMetric other = (AggregatedLogOddsMetric)obj;
        return this.hasVariableNames() == other.hasVariableNames() && Objects.equals(this.variableNames(), other.variableNames()) && Objects.equals(this.aggregatedVariablesImportance(), other.aggregatedVariablesImportance());
    }

    public final String toString() {
        return ToString.builder((String)"AggregatedLogOddsMetric").add("VariableNames", this.hasVariableNames() ? this.variableNames() : null).add("AggregatedVariablesImportance", (Object)this.aggregatedVariablesImportance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variableNames": {
                return Optional.ofNullable(clazz.cast(this.variableNames()));
            }
            case "aggregatedVariablesImportance": {
                return Optional.ofNullable(clazz.cast(this.aggregatedVariablesImportance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedLogOddsMetric, T> g) {
        return obj -> g.apply((AggregatedLogOddsMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> variableNames = DefaultSdkAutoConstructList.getInstance();
        private Float aggregatedVariablesImportance;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedLogOddsMetric model) {
            this.variableNames(model.variableNames);
            this.aggregatedVariablesImportance(model.aggregatedVariablesImportance);
        }

        public final Collection<String> getVariableNames() {
            if (this.variableNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.variableNames;
        }

        public final void setVariableNames(Collection<String> variableNames) {
            this.variableNames = ListOfStringsCopier.copy(variableNames);
        }

        @Override
        public final Builder variableNames(Collection<String> variableNames) {
            this.variableNames = ListOfStringsCopier.copy(variableNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableNames(String ... variableNames) {
            this.variableNames(Arrays.asList(variableNames));
            return this;
        }

        public final Float getAggregatedVariablesImportance() {
            return this.aggregatedVariablesImportance;
        }

        public final void setAggregatedVariablesImportance(Float aggregatedVariablesImportance) {
            this.aggregatedVariablesImportance = aggregatedVariablesImportance;
        }

        @Override
        public final Builder aggregatedVariablesImportance(Float aggregatedVariablesImportance) {
            this.aggregatedVariablesImportance = aggregatedVariablesImportance;
            return this;
        }

        public AggregatedLogOddsMetric build() {
            return new AggregatedLogOddsMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregatedLogOddsMetric> {
        public Builder variableNames(Collection<String> var1);

        public Builder variableNames(String ... var1);

        public Builder aggregatedVariablesImportance(Float var1);
    }
}

