/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelInputDataFormat {
    TEXT_CSV("TEXT_CSV"),
    APPLICATION_JSON("APPLICATION_JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelInputDataFormat> VALUE_MAP;
    private final String value;

    private ModelInputDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelInputDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelInputDataFormat> knownValues() {
        EnumSet<ModelInputDataFormat> knownValues = EnumSet.allOf(ModelInputDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelInputDataFormat.class, ModelInputDataFormat::toString);
    }
}

