/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.Rule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRuleMetadataRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, UpdateRuleMetadataRequest> {
    private static final SdkField<Rule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rule").getter(UpdateRuleMetadataRequest.getter(UpdateRuleMetadataRequest::rule)).setter(UpdateRuleMetadataRequest.setter(Builder::rule)).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateRuleMetadataRequest.getter(UpdateRuleMetadataRequest::description)).setter(UpdateRuleMetadataRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD, DESCRIPTION_FIELD));
    private final Rule rule;
    private final String description;

    private UpdateRuleMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.rule = builder.rule;
        this.description = builder.description;
    }

    public final Rule rule() {
        return this.rule;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleMetadataRequest)) {
            return false;
        }
        UpdateRuleMetadataRequest other = (UpdateRuleMetadataRequest)((Object)obj);
        return Objects.equals(this.rule(), other.rule()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRuleMetadataRequest").add("Rule", (Object)this.rule()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleMetadataRequest, T> g) {
        return obj -> g.apply((UpdateRuleMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private Rule rule;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleMetadataRequest model) {
            super(model);
            this.rule(model.rule);
            this.description(model.description);
        }

        public final Rule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleMetadataRequest build() {
            return new UpdateRuleMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRuleMetadataRequest> {
        public Builder rule(Rule var1);

        default public Builder rule(Consumer<Rule.Builder> rule) {
            return this.rule((Rule)((Rule.Builder)Rule.builder().applyMutation(rule)).build());
        }

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

