/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.AsyncJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPrediction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchPrediction> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(BatchPrediction.getter(BatchPrediction::jobId)).setter(BatchPrediction.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BatchPrediction.getter(BatchPrediction::statusAsString)).setter(BatchPrediction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(BatchPrediction.getter(BatchPrediction::failureReason)).setter(BatchPrediction.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startTime").getter(BatchPrediction.getter(BatchPrediction::startTime)).setter(BatchPrediction.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("completionTime").getter(BatchPrediction.getter(BatchPrediction::completionTime)).setter(BatchPrediction.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()}).build();
    private static final SdkField<String> LAST_HEARTBEAT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastHeartbeatTime").getter(BatchPrediction.getter(BatchPrediction::lastHeartbeatTime)).setter(BatchPrediction.setter(Builder::lastHeartbeatTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastHeartbeatTime").build()}).build();
    private static final SdkField<String> INPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputPath").getter(BatchPrediction.getter(BatchPrediction::inputPath)).setter(BatchPrediction.setter(Builder::inputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPath").build()}).build();
    private static final SdkField<String> OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputPath").getter(BatchPrediction.getter(BatchPrediction::outputPath)).setter(BatchPrediction.setter(Builder::outputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputPath").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(BatchPrediction.getter(BatchPrediction::eventTypeName)).setter(BatchPrediction.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorName").getter(BatchPrediction.getter(BatchPrediction::detectorName)).setter(BatchPrediction.setter(Builder::detectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersion").getter(BatchPrediction.getter(BatchPrediction::detectorVersion)).setter(BatchPrediction.setter(Builder::detectorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersion").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRoleArn").getter(BatchPrediction.getter(BatchPrediction::iamRoleArn)).setter(BatchPrediction.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(BatchPrediction.getter(BatchPrediction::arn)).setter(BatchPrediction.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Integer> PROCESSED_RECORDS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("processedRecordsCount").getter(BatchPrediction.getter(BatchPrediction::processedRecordsCount)).setter(BatchPrediction.setter(Builder::processedRecordsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processedRecordsCount").build()}).build();
    private static final SdkField<Integer> TOTAL_RECORDS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalRecordsCount").getter(BatchPrediction.getter(BatchPrediction::totalRecordsCount)).setter(BatchPrediction.setter(Builder::totalRecordsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecordsCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LAST_HEARTBEAT_TIME_FIELD, INPUT_PATH_FIELD, OUTPUT_PATH_FIELD, EVENT_TYPE_NAME_FIELD, DETECTOR_NAME_FIELD, DETECTOR_VERSION_FIELD, IAM_ROLE_ARN_FIELD, ARN_FIELD, PROCESSED_RECORDS_COUNT_FIELD, TOTAL_RECORDS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String status;
    private final String failureReason;
    private final String startTime;
    private final String completionTime;
    private final String lastHeartbeatTime;
    private final String inputPath;
    private final String outputPath;
    private final String eventTypeName;
    private final String detectorName;
    private final String detectorVersion;
    private final String iamRoleArn;
    private final String arn;
    private final Integer processedRecordsCount;
    private final Integer totalRecordsCount;

    private BatchPrediction(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.lastHeartbeatTime = builder.lastHeartbeatTime;
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
        this.eventTypeName = builder.eventTypeName;
        this.detectorName = builder.detectorName;
        this.detectorVersion = builder.detectorVersion;
        this.iamRoleArn = builder.iamRoleArn;
        this.arn = builder.arn;
        this.processedRecordsCount = builder.processedRecordsCount;
        this.totalRecordsCount = builder.totalRecordsCount;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final AsyncJobStatus status() {
        return AsyncJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String completionTime() {
        return this.completionTime;
    }

    public final String lastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public final String inputPath() {
        return this.inputPath;
    }

    public final String outputPath() {
        return this.outputPath;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final String detectorName() {
        return this.detectorName;
    }

    public final String detectorVersion() {
        return this.detectorVersion;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer processedRecordsCount() {
        return this.processedRecordsCount;
    }

    public final Integer totalRecordsCount() {
        return this.totalRecordsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastHeartbeatTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.processedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRecordsCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPrediction)) {
            return false;
        }
        BatchPrediction other = (BatchPrediction)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.lastHeartbeatTime(), other.lastHeartbeatTime()) && Objects.equals(this.inputPath(), other.inputPath()) && Objects.equals(this.outputPath(), other.outputPath()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.detectorName(), other.detectorName()) && Objects.equals(this.detectorVersion(), other.detectorVersion()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.processedRecordsCount(), other.processedRecordsCount()) && Objects.equals(this.totalRecordsCount(), other.totalRecordsCount());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPrediction").add("JobId", (Object)this.jobId()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("StartTime", (Object)this.startTime()).add("CompletionTime", (Object)this.completionTime()).add("LastHeartbeatTime", (Object)this.lastHeartbeatTime()).add("InputPath", (Object)this.inputPath()).add("OutputPath", (Object)this.outputPath()).add("EventTypeName", (Object)this.eventTypeName()).add("DetectorName", (Object)this.detectorName()).add("DetectorVersion", (Object)this.detectorVersion()).add("IamRoleArn", (Object)this.iamRoleArn()).add("Arn", (Object)this.arn()).add("ProcessedRecordsCount", (Object)this.processedRecordsCount()).add("TotalRecordsCount", (Object)this.totalRecordsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "lastHeartbeatTime": {
                return Optional.ofNullable(clazz.cast(this.lastHeartbeatTime()));
            }
            case "inputPath": {
                return Optional.ofNullable(clazz.cast(this.inputPath()));
            }
            case "outputPath": {
                return Optional.ofNullable(clazz.cast(this.outputPath()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "detectorName": {
                return Optional.ofNullable(clazz.cast(this.detectorName()));
            }
            case "detectorVersion": {
                return Optional.ofNullable(clazz.cast(this.detectorVersion()));
            }
            case "iamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "processedRecordsCount": {
                return Optional.ofNullable(clazz.cast(this.processedRecordsCount()));
            }
            case "totalRecordsCount": {
                return Optional.ofNullable(clazz.cast(this.totalRecordsCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPrediction, T> g) {
        return obj -> g.apply((BatchPrediction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String status;
        private String failureReason;
        private String startTime;
        private String completionTime;
        private String lastHeartbeatTime;
        private String inputPath;
        private String outputPath;
        private String eventTypeName;
        private String detectorName;
        private String detectorVersion;
        private String iamRoleArn;
        private String arn;
        private Integer processedRecordsCount;
        private Integer totalRecordsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPrediction model) {
            this.jobId(model.jobId);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.startTime(model.startTime);
            this.completionTime(model.completionTime);
            this.lastHeartbeatTime(model.lastHeartbeatTime);
            this.inputPath(model.inputPath);
            this.outputPath(model.outputPath);
            this.eventTypeName(model.eventTypeName);
            this.detectorName(model.detectorName);
            this.detectorVersion(model.detectorVersion);
            this.iamRoleArn(model.iamRoleArn);
            this.arn(model.arn);
            this.processedRecordsCount(model.processedRecordsCount);
            this.totalRecordsCount(model.totalRecordsCount);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AsyncJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(String completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(String completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLastHeartbeatTime() {
            return this.lastHeartbeatTime;
        }

        public final void setLastHeartbeatTime(String lastHeartbeatTime) {
            this.lastHeartbeatTime = lastHeartbeatTime;
        }

        @Override
        public final Builder lastHeartbeatTime(String lastHeartbeatTime) {
            this.lastHeartbeatTime = lastHeartbeatTime;
            return this;
        }

        public final String getInputPath() {
            return this.inputPath;
        }

        public final void setInputPath(String inputPath) {
            this.inputPath = inputPath;
        }

        @Override
        public final Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public final String getOutputPath() {
            return this.outputPath;
        }

        public final void setOutputPath(String outputPath) {
            this.outputPath = outputPath;
        }

        @Override
        public final Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getDetectorName() {
            return this.detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final String getDetectorVersion() {
            return this.detectorVersion;
        }

        public final void setDetectorVersion(String detectorVersion) {
            this.detectorVersion = detectorVersion;
        }

        @Override
        public final Builder detectorVersion(String detectorVersion) {
            this.detectorVersion = detectorVersion;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getProcessedRecordsCount() {
            return this.processedRecordsCount;
        }

        public final void setProcessedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
        }

        @Override
        public final Builder processedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public final Integer getTotalRecordsCount() {
            return this.totalRecordsCount;
        }

        public final void setTotalRecordsCount(Integer totalRecordsCount) {
            this.totalRecordsCount = totalRecordsCount;
        }

        @Override
        public final Builder totalRecordsCount(Integer totalRecordsCount) {
            this.totalRecordsCount = totalRecordsCount;
            return this;
        }

        public BatchPrediction build() {
            return new BatchPrediction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchPrediction> {
        public Builder jobId(String var1);

        public Builder status(String var1);

        public Builder status(AsyncJobStatus var1);

        public Builder failureReason(String var1);

        public Builder startTime(String var1);

        public Builder completionTime(String var1);

        public Builder lastHeartbeatTime(String var1);

        public Builder inputPath(String var1);

        public Builder outputPath(String var1);

        public Builder eventTypeName(String var1);

        public Builder detectorName(String var1);

        public Builder detectorVersion(String var1);

        public Builder iamRoleArn(String var1);

        public Builder arn(String var1);

        public Builder processedRecordsCount(Integer var1);

        public Builder totalRecordsCount(Integer var1);
    }
}

