/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.EventIngestion;
import software.amazon.awssdk.services.frauddetector.model.IngestedEventStatistics;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.services.frauddetector.model.NonEmptyListOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventType> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EventType.getter(EventType::name)).setter(EventType.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EventType.getter(EventType::description)).setter(EventType.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EVENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventVariables").getter(EventType.getter(EventType::eventVariables)).setter(EventType.setter(Builder::eventVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("labels").getter(EventType.getter(EventType::labels)).setter(EventType.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entityTypes").getter(EventType.getter(EventType::entityTypes)).setter(EventType.setter(Builder::entityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_INGESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventIngestion").getter(EventType.getter(EventType::eventIngestionAsString)).setter(EventType.setter(Builder::eventIngestion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventIngestion").build()}).build();
    private static final SdkField<IngestedEventStatistics> INGESTED_EVENT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ingestedEventStatistics").getter(EventType.getter(EventType::ingestedEventStatistics)).setter(EventType.setter(Builder::ingestedEventStatistics)).constructor(IngestedEventStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestedEventStatistics").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedTime").getter(EventType.getter(EventType::lastUpdatedTime)).setter(EventType.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdTime").getter(EventType.getter(EventType::createdTime)).setter(EventType.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EventType.getter(EventType::arn)).setter(EventType.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, EVENT_VARIABLES_FIELD, LABELS_FIELD, ENTITY_TYPES_FIELD, EVENT_INGESTION_FIELD, INGESTED_EVENT_STATISTICS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<String> eventVariables;
    private final List<String> labels;
    private final List<String> entityTypes;
    private final String eventIngestion;
    private final IngestedEventStatistics ingestedEventStatistics;
    private final String lastUpdatedTime;
    private final String createdTime;
    private final String arn;

    private EventType(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.eventVariables = builder.eventVariables;
        this.labels = builder.labels;
        this.entityTypes = builder.entityTypes;
        this.eventIngestion = builder.eventIngestion;
        this.ingestedEventStatistics = builder.ingestedEventStatistics;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEventVariables() {
        return this.eventVariables != null && !(this.eventVariables instanceof SdkAutoConstructList);
    }

    public final List<String> eventVariables() {
        return this.eventVariables;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public final boolean hasEntityTypes() {
        return this.entityTypes != null && !(this.entityTypes instanceof SdkAutoConstructList);
    }

    public final List<String> entityTypes() {
        return this.entityTypes;
    }

    public final EventIngestion eventIngestion() {
        return EventIngestion.fromValue(this.eventIngestion);
    }

    public final String eventIngestionAsString() {
        return this.eventIngestion;
    }

    public final IngestedEventStatistics ingestedEventStatistics() {
        return this.ingestedEventStatistics;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventVariables() ? this.eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityTypes() ? this.entityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventIngestionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestedEventStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventType)) {
            return false;
        }
        EventType other = (EventType)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasEventVariables() == other.hasEventVariables() && Objects.equals(this.eventVariables(), other.eventVariables()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && this.hasEntityTypes() == other.hasEntityTypes() && Objects.equals(this.entityTypes(), other.entityTypes()) && Objects.equals(this.eventIngestionAsString(), other.eventIngestionAsString()) && Objects.equals(this.ingestedEventStatistics(), other.ingestedEventStatistics()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"EventType").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("EventVariables", this.hasEventVariables() ? this.eventVariables() : null).add("Labels", this.hasLabels() ? this.labels() : null).add("EntityTypes", this.hasEntityTypes() ? this.entityTypes() : null).add("EventIngestion", (Object)this.eventIngestionAsString()).add("IngestedEventStatistics", (Object)this.ingestedEventStatistics()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "eventVariables": {
                return Optional.ofNullable(clazz.cast(this.eventVariables()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "entityTypes": {
                return Optional.ofNullable(clazz.cast(this.entityTypes()));
            }
            case "eventIngestion": {
                return Optional.ofNullable(clazz.cast(this.eventIngestionAsString()));
            }
            case "ingestedEventStatistics": {
                return Optional.ofNullable(clazz.cast(this.ingestedEventStatistics()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventType, T> g) {
        return obj -> g.apply((EventType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> eventVariables = DefaultSdkAutoConstructList.getInstance();
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();
        private String eventIngestion;
        private IngestedEventStatistics ingestedEventStatistics;
        private String lastUpdatedTime;
        private String createdTime;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventType model) {
            this.name(model.name);
            this.description(model.description);
            this.eventVariables(model.eventVariables);
            this.labels(model.labels);
            this.entityTypes(model.entityTypes);
            this.eventIngestion(model.eventIngestion);
            this.ingestedEventStatistics(model.ingestedEventStatistics);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
            this.arn(model.arn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEventVariables() {
            if (this.eventVariables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventVariables;
        }

        public final void setEventVariables(Collection<String> eventVariables) {
            this.eventVariables = ListOfStringsCopier.copy(eventVariables);
        }

        @Override
        public final Builder eventVariables(Collection<String> eventVariables) {
            this.eventVariables = ListOfStringsCopier.copy(eventVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventVariables(String ... eventVariables) {
            this.eventVariables(Arrays.asList(eventVariables));
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ListOfStringsCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ListOfStringsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final Collection<String> getEntityTypes() {
            if (this.entityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityTypes;
        }

        public final void setEntityTypes(Collection<String> entityTypes) {
            this.entityTypes = NonEmptyListOfStringsCopier.copy(entityTypes);
        }

        @Override
        public final Builder entityTypes(Collection<String> entityTypes) {
            this.entityTypes = NonEmptyListOfStringsCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(String ... entityTypes) {
            this.entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final String getEventIngestion() {
            return this.eventIngestion;
        }

        public final void setEventIngestion(String eventIngestion) {
            this.eventIngestion = eventIngestion;
        }

        @Override
        public final Builder eventIngestion(String eventIngestion) {
            this.eventIngestion = eventIngestion;
            return this;
        }

        @Override
        public final Builder eventIngestion(EventIngestion eventIngestion) {
            this.eventIngestion(eventIngestion == null ? null : eventIngestion.toString());
            return this;
        }

        public final IngestedEventStatistics.Builder getIngestedEventStatistics() {
            return this.ingestedEventStatistics != null ? this.ingestedEventStatistics.toBuilder() : null;
        }

        public final void setIngestedEventStatistics(IngestedEventStatistics.BuilderImpl ingestedEventStatistics) {
            this.ingestedEventStatistics = ingestedEventStatistics != null ? ingestedEventStatistics.build() : null;
        }

        @Override
        public final Builder ingestedEventStatistics(IngestedEventStatistics ingestedEventStatistics) {
            this.ingestedEventStatistics = ingestedEventStatistics;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public EventType build() {
            return new EventType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventType> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder eventVariables(Collection<String> var1);

        public Builder eventVariables(String ... var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder entityTypes(Collection<String> var1);

        public Builder entityTypes(String ... var1);

        public Builder eventIngestion(String var1);

        public Builder eventIngestion(EventIngestion var1);

        public Builder ingestedEventStatistics(IngestedEventStatistics var1);

        default public Builder ingestedEventStatistics(Consumer<IngestedEventStatistics.Builder> ingestedEventStatistics) {
            return this.ingestedEventStatistics((IngestedEventStatistics)((IngestedEventStatistics.Builder)IngestedEventStatistics.builder().applyMutation(ingestedEventStatistics)).build());
        }

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);

        public Builder arn(String var1);
    }
}

