/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.model.GetListElementsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetListElementsResponse;

public class GetListElementsPublisher
implements SdkPublisher<GetListElementsResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetListElementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetListElementsPublisher(FraudDetectorAsyncClient client, GetListElementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetListElementsPublisher(FraudDetectorAsyncClient client, GetListElementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetListElementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetListElementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetListElementsResponseFetcher
    implements AsyncPageFetcher<GetListElementsResponse> {
        private GetListElementsResponseFetcher() {
        }

        public boolean hasNextPage(GetListElementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetListElementsResponse> nextPage(GetListElementsResponse previousPage) {
            if (previousPage == null) {
                return GetListElementsPublisher.this.client.getListElements(GetListElementsPublisher.this.firstRequest);
            }
            return GetListElementsPublisher.this.client.getListElements((GetListElementsRequest)((Object)GetListElementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

