/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse;

public class ListEventPredictionsIterable
implements SdkIterable<ListEventPredictionsResponse> {
    private final FraudDetectorClient client;
    private final ListEventPredictionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventPredictionsIterable(FraudDetectorClient client, ListEventPredictionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventPredictionsResponseFetcher();
    }

    public Iterator<ListEventPredictionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEventPredictionsResponseFetcher
    implements SyncPageFetcher<ListEventPredictionsResponse> {
        private ListEventPredictionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventPredictionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventPredictionsResponse nextPage(ListEventPredictionsResponse previousPage) {
            if (previousPage == null) {
                return ListEventPredictionsIterable.this.client.listEventPredictions(ListEventPredictionsIterable.this.firstRequest);
            }
            return ListEventPredictionsIterable.this.client.listEventPredictions((ListEventPredictionsRequest)((Object)ListEventPredictionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

