/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.model.GetListsMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.GetListsMetadataResponse;

public class GetListsMetadataPublisher
implements SdkPublisher<GetListsMetadataResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetListsMetadataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetListsMetadataPublisher(FraudDetectorAsyncClient client, GetListsMetadataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetListsMetadataPublisher(FraudDetectorAsyncClient client, GetListsMetadataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetListsMetadataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetListsMetadataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetListsMetadataResponseFetcher
    implements AsyncPageFetcher<GetListsMetadataResponse> {
        private GetListsMetadataResponseFetcher() {
        }

        public boolean hasNextPage(GetListsMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetListsMetadataResponse> nextPage(GetListsMetadataResponse previousPage) {
            if (previousPage == null) {
                return GetListsMetadataPublisher.this.client.getListsMetadata(GetListsMetadataPublisher.this.firstRequest);
            }
            return GetListsMetadataPublisher.this.client.getListsMetadata((GetListsMetadataRequest)((Object)GetListsMetadataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

