/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestedEventStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestedEventStatistics> {
    private static final SdkField<Long> NUMBER_OF_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfEvents").getter(IngestedEventStatistics.getter(IngestedEventStatistics::numberOfEvents)).setter(IngestedEventStatistics.setter(Builder::numberOfEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfEvents").build()}).build();
    private static final SdkField<Long> EVENT_DATA_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("eventDataSizeInBytes").getter(IngestedEventStatistics.getter(IngestedEventStatistics::eventDataSizeInBytes)).setter(IngestedEventStatistics.setter(Builder::eventDataSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDataSizeInBytes").build()}).build();
    private static final SdkField<String> LEAST_RECENT_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("leastRecentEvent").getter(IngestedEventStatistics.getter(IngestedEventStatistics::leastRecentEvent)).setter(IngestedEventStatistics.setter(Builder::leastRecentEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("leastRecentEvent").build()}).build();
    private static final SdkField<String> MOST_RECENT_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mostRecentEvent").getter(IngestedEventStatistics.getter(IngestedEventStatistics::mostRecentEvent)).setter(IngestedEventStatistics.setter(Builder::mostRecentEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentEvent").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedTime").getter(IngestedEventStatistics.getter(IngestedEventStatistics::lastUpdatedTime)).setter(IngestedEventStatistics.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_EVENTS_FIELD, EVENT_DATA_SIZE_IN_BYTES_FIELD, LEAST_RECENT_EVENT_FIELD, MOST_RECENT_EVENT_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long numberOfEvents;
    private final Long eventDataSizeInBytes;
    private final String leastRecentEvent;
    private final String mostRecentEvent;
    private final String lastUpdatedTime;

    private IngestedEventStatistics(BuilderImpl builder) {
        this.numberOfEvents = builder.numberOfEvents;
        this.eventDataSizeInBytes = builder.eventDataSizeInBytes;
        this.leastRecentEvent = builder.leastRecentEvent;
        this.mostRecentEvent = builder.mostRecentEvent;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final Long numberOfEvents() {
        return this.numberOfEvents;
    }

    public final Long eventDataSizeInBytes() {
        return this.eventDataSizeInBytes;
    }

    public final String leastRecentEvent() {
        return this.leastRecentEvent;
    }

    public final String mostRecentEvent() {
        return this.mostRecentEvent;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.leastRecentEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.mostRecentEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestedEventStatistics)) {
            return false;
        }
        IngestedEventStatistics other = (IngestedEventStatistics)obj;
        return Objects.equals(this.numberOfEvents(), other.numberOfEvents()) && Objects.equals(this.eventDataSizeInBytes(), other.eventDataSizeInBytes()) && Objects.equals(this.leastRecentEvent(), other.leastRecentEvent()) && Objects.equals(this.mostRecentEvent(), other.mostRecentEvent()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"IngestedEventStatistics").add("NumberOfEvents", (Object)this.numberOfEvents()).add("EventDataSizeInBytes", (Object)this.eventDataSizeInBytes()).add("LeastRecentEvent", (Object)this.leastRecentEvent()).add("MostRecentEvent", (Object)this.mostRecentEvent()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numberOfEvents": {
                return Optional.ofNullable(clazz.cast(this.numberOfEvents()));
            }
            case "eventDataSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.eventDataSizeInBytes()));
            }
            case "leastRecentEvent": {
                return Optional.ofNullable(clazz.cast(this.leastRecentEvent()));
            }
            case "mostRecentEvent": {
                return Optional.ofNullable(clazz.cast(this.mostRecentEvent()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestedEventStatistics, T> g) {
        return obj -> g.apply((IngestedEventStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numberOfEvents;
        private Long eventDataSizeInBytes;
        private String leastRecentEvent;
        private String mostRecentEvent;
        private String lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestedEventStatistics model) {
            this.numberOfEvents(model.numberOfEvents);
            this.eventDataSizeInBytes(model.eventDataSizeInBytes);
            this.leastRecentEvent(model.leastRecentEvent);
            this.mostRecentEvent(model.mostRecentEvent);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final Long getNumberOfEvents() {
            return this.numberOfEvents;
        }

        public final void setNumberOfEvents(Long numberOfEvents) {
            this.numberOfEvents = numberOfEvents;
        }

        @Override
        @Transient
        public final Builder numberOfEvents(Long numberOfEvents) {
            this.numberOfEvents = numberOfEvents;
            return this;
        }

        public final Long getEventDataSizeInBytes() {
            return this.eventDataSizeInBytes;
        }

        public final void setEventDataSizeInBytes(Long eventDataSizeInBytes) {
            this.eventDataSizeInBytes = eventDataSizeInBytes;
        }

        @Override
        @Transient
        public final Builder eventDataSizeInBytes(Long eventDataSizeInBytes) {
            this.eventDataSizeInBytes = eventDataSizeInBytes;
            return this;
        }

        public final String getLeastRecentEvent() {
            return this.leastRecentEvent;
        }

        public final void setLeastRecentEvent(String leastRecentEvent) {
            this.leastRecentEvent = leastRecentEvent;
        }

        @Override
        @Transient
        public final Builder leastRecentEvent(String leastRecentEvent) {
            this.leastRecentEvent = leastRecentEvent;
            return this;
        }

        public final String getMostRecentEvent() {
            return this.mostRecentEvent;
        }

        public final void setMostRecentEvent(String mostRecentEvent) {
            this.mostRecentEvent = mostRecentEvent;
        }

        @Override
        @Transient
        public final Builder mostRecentEvent(String mostRecentEvent) {
            this.mostRecentEvent = mostRecentEvent;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public IngestedEventStatistics build() {
            return new IngestedEventStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestedEventStatistics> {
        public Builder numberOfEvents(Long var1);

        public Builder eventDataSizeInBytes(Long var1);

        public Builder leastRecentEvent(String var1);

        public Builder mostRecentEvent(String var1);

        public Builder lastUpdatedTime(String var1);
    }
}

