/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.Variable;
import software.amazon.awssdk.services.frauddetector.model.VariableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVariablesResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetVariablesResponse> {
    private static final SdkField<List<Variable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(GetVariablesResponse.getter(GetVariablesResponse::variables)).setter(GetVariablesResponse.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Variable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetVariablesResponse.getter(GetVariablesResponse::nextToken)).setter(GetVariablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Variable> variables;
    private final String nextToken;

    private GetVariablesResponse(BuilderImpl builder) {
        super(builder);
        this.variables = builder.variables;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<Variable> variables() {
        return this.variables;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVariablesResponse)) {
            return false;
        }
        GetVariablesResponse other = (GetVariablesResponse)((Object)obj);
        return this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetVariablesResponse").add("Variables", this.hasVariables() ? this.variables() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVariablesResponse, T> g) {
        return obj -> g.apply((GetVariablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<Variable> variables = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVariablesResponse model) {
            super(model);
            this.variables(model.variables);
            this.nextToken(model.nextToken);
        }

        public final List<Variable.Builder> getVariables() {
            List<Variable.Builder> result = VariableListCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<Variable.BuilderImpl> variables) {
            this.variables = VariableListCopier.copyFromBuilder(variables);
        }

        @Override
        @Transient
        public final Builder variables(Collection<Variable> variables) {
            this.variables = VariableListCopier.copy(variables);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder variables(Variable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder variables(Consumer<Variable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (Variable)((Variable.Builder)Variable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetVariablesResponse build() {
            return new GetVariablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVariablesResponse> {
        public Builder variables(Collection<Variable> var1);

        public Builder variables(Variable ... var1);

        public Builder variables(Consumer<Variable.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

