/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ListOfLogitMetricsCopier;
import software.amazon.awssdk.services.frauddetector.model.LogitMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VariableImportanceMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VariableImportanceMetrics> {
    private static final SdkField<List<LogitMetric>> LOGIT_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogitMetrics").getter(VariableImportanceMetrics.getter(VariableImportanceMetrics::logitMetrics)).setter(VariableImportanceMetrics.setter(Builder::logitMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogitMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogitMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGIT_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<LogitMetric> logitMetrics;

    private VariableImportanceMetrics(BuilderImpl builder) {
        this.logitMetrics = builder.logitMetrics;
    }

    public final boolean hasLogitMetrics() {
        return this.logitMetrics != null && !(this.logitMetrics instanceof SdkAutoConstructList);
    }

    public final List<LogitMetric> logitMetrics() {
        return this.logitMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogitMetrics() ? this.logitMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableImportanceMetrics)) {
            return false;
        }
        VariableImportanceMetrics other = (VariableImportanceMetrics)obj;
        return this.hasLogitMetrics() == other.hasLogitMetrics() && Objects.equals(this.logitMetrics(), other.logitMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"VariableImportanceMetrics").add("LogitMetrics", this.hasLogitMetrics() ? this.logitMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogitMetrics": {
                return Optional.ofNullable(clazz.cast(this.logitMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableImportanceMetrics, T> g) {
        return obj -> g.apply((VariableImportanceMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LogitMetric> logitMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VariableImportanceMetrics model) {
            this.logitMetrics(model.logitMetrics);
        }

        public final List<LogitMetric.Builder> getLogitMetrics() {
            List<LogitMetric.Builder> result = ListOfLogitMetricsCopier.copyToBuilder(this.logitMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder logitMetrics(Collection<LogitMetric> logitMetrics) {
            this.logitMetrics = ListOfLogitMetricsCopier.copy(logitMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logitMetrics(LogitMetric ... logitMetrics) {
            this.logitMetrics(Arrays.asList(logitMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logitMetrics(Consumer<LogitMetric.Builder> ... logitMetrics) {
            this.logitMetrics(Stream.of(logitMetrics).map(c -> (LogitMetric)((LogitMetric.Builder)LogitMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogitMetrics(Collection<LogitMetric.BuilderImpl> logitMetrics) {
            this.logitMetrics = ListOfLogitMetricsCopier.copyFromBuilder(logitMetrics);
        }

        public VariableImportanceMetrics build() {
            return new VariableImportanceMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VariableImportanceMetrics> {
        public Builder logitMetrics(Collection<LogitMetric> var1);

        public Builder logitMetrics(LogitMetric ... var1);

        public Builder logitMetrics(Consumer<LogitMetric.Builder> ... var1);
    }
}

