/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.RuleDetail;
import software.amazon.awssdk.services.frauddetector.model.RuleDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRulesResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetRulesResponse> {
    private static final SdkField<List<RuleDetail>> RULE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleDetails").getter(GetRulesResponse.getter(GetRulesResponse::ruleDetails)).setter(GetRulesResponse.setter(Builder::ruleDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetRulesResponse.getter(GetRulesResponse::nextToken)).setter(GetRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RuleDetail> ruleDetails;
    private final String nextToken;

    private GetRulesResponse(BuilderImpl builder) {
        super(builder);
        this.ruleDetails = builder.ruleDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuleDetails() {
        return this.ruleDetails != null && !(this.ruleDetails instanceof SdkAutoConstructList);
    }

    public final List<RuleDetail> ruleDetails() {
        return this.ruleDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleDetails() ? this.ruleDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRulesResponse)) {
            return false;
        }
        GetRulesResponse other = (GetRulesResponse)((Object)obj);
        return this.hasRuleDetails() == other.hasRuleDetails() && Objects.equals(this.ruleDetails(), other.ruleDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRulesResponse").add("RuleDetails", this.hasRuleDetails() ? this.ruleDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleDetails": {
                return Optional.ofNullable(clazz.cast(this.ruleDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRulesResponse, T> g) {
        return obj -> g.apply((GetRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<RuleDetail> ruleDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRulesResponse model) {
            super(model);
            this.ruleDetails(model.ruleDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<RuleDetail.Builder> getRuleDetails() {
            if (this.ruleDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleDetails != null ? (Collection)this.ruleDetails.stream().map(RuleDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ruleDetails(Collection<RuleDetail> ruleDetails) {
            this.ruleDetails = RuleDetailListCopier.copy(ruleDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleDetails(RuleDetail ... ruleDetails) {
            this.ruleDetails(Arrays.asList(ruleDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleDetails(Consumer<RuleDetail.Builder> ... ruleDetails) {
            this.ruleDetails(Stream.of(ruleDetails).map(c -> (RuleDetail)((RuleDetail.Builder)RuleDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRuleDetails(Collection<RuleDetail.BuilderImpl> ruleDetails) {
            this.ruleDetails = RuleDetailListCopier.copyFromBuilder(ruleDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetRulesResponse build() {
            return new GetRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRulesResponse> {
        public Builder ruleDetails(Collection<RuleDetail> var1);

        public Builder ruleDetails(RuleDetail ... var1);

        public Builder ruleDetails(Consumer<RuleDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

