/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ModelEndpointStatus;
import software.amazon.awssdk.services.frauddetector.model.ModelInputConfiguration;
import software.amazon.awssdk.services.frauddetector.model.ModelOutputConfiguration;
import software.amazon.awssdk.services.frauddetector.model.ModelSource;
import software.amazon.awssdk.services.frauddetector.model.Tag;
import software.amazon.awssdk.services.frauddetector.model._tagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutExternalModelRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, PutExternalModelRequest> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelEndpoint").getter(PutExternalModelRequest.getter(PutExternalModelRequest::modelEndpoint)).setter(PutExternalModelRequest.setter(Builder::modelEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()}).build();
    private static final SdkField<String> MODEL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelSource").getter(PutExternalModelRequest.getter(PutExternalModelRequest::modelSourceAsString)).setter(PutExternalModelRequest.setter(Builder::modelSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()}).build();
    private static final SdkField<String> INVOKE_MODEL_ENDPOINT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invokeModelEndpointRoleArn").getter(PutExternalModelRequest.getter(PutExternalModelRequest::invokeModelEndpointRoleArn)).setter(PutExternalModelRequest.setter(Builder::invokeModelEndpointRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokeModelEndpointRoleArn").build()}).build();
    private static final SdkField<ModelInputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConfiguration").getter(PutExternalModelRequest.getter(PutExternalModelRequest::inputConfiguration)).setter(PutExternalModelRequest.setter(Builder::inputConfiguration)).constructor(ModelInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build()}).build();
    private static final SdkField<ModelOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(PutExternalModelRequest.getter(PutExternalModelRequest::outputConfiguration)).setter(PutExternalModelRequest.setter(Builder::outputConfiguration)).constructor(ModelOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<String> MODEL_ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelEndpointStatus").getter(PutExternalModelRequest.getter(PutExternalModelRequest::modelEndpointStatusAsString)).setter(PutExternalModelRequest.setter(Builder::modelEndpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpointStatus").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(PutExternalModelRequest.getter(PutExternalModelRequest::tags)).setter(PutExternalModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD, MODEL_SOURCE_FIELD, INVOKE_MODEL_ENDPOINT_ROLE_ARN_FIELD, INPUT_CONFIGURATION_FIELD, OUTPUT_CONFIGURATION_FIELD, MODEL_ENDPOINT_STATUS_FIELD, TAGS_FIELD));
    private final String modelEndpoint;
    private final String modelSource;
    private final String invokeModelEndpointRoleArn;
    private final ModelInputConfiguration inputConfiguration;
    private final ModelOutputConfiguration outputConfiguration;
    private final String modelEndpointStatus;
    private final List<Tag> tags;

    private PutExternalModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelEndpoint = builder.modelEndpoint;
        this.modelSource = builder.modelSource;
        this.invokeModelEndpointRoleArn = builder.invokeModelEndpointRoleArn;
        this.inputConfiguration = builder.inputConfiguration;
        this.outputConfiguration = builder.outputConfiguration;
        this.modelEndpointStatus = builder.modelEndpointStatus;
        this.tags = builder.tags;
    }

    public final String modelEndpoint() {
        return this.modelEndpoint;
    }

    public final ModelSource modelSource() {
        return ModelSource.fromValue(this.modelSource);
    }

    public final String modelSourceAsString() {
        return this.modelSource;
    }

    public final String invokeModelEndpointRoleArn() {
        return this.invokeModelEndpointRoleArn;
    }

    public final ModelInputConfiguration inputConfiguration() {
        return this.inputConfiguration;
    }

    public final ModelOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public final ModelEndpointStatus modelEndpointStatus() {
        return ModelEndpointStatus.fromValue(this.modelEndpointStatus);
    }

    public final String modelEndpointStatusAsString() {
        return this.modelEndpointStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokeModelEndpointRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutExternalModelRequest)) {
            return false;
        }
        PutExternalModelRequest other = (PutExternalModelRequest)((Object)obj);
        return Objects.equals(this.modelEndpoint(), other.modelEndpoint()) && Objects.equals(this.modelSourceAsString(), other.modelSourceAsString()) && Objects.equals(this.invokeModelEndpointRoleArn(), other.invokeModelEndpointRoleArn()) && Objects.equals(this.inputConfiguration(), other.inputConfiguration()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.modelEndpointStatusAsString(), other.modelEndpointStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutExternalModelRequest").add("ModelEndpoint", (Object)this.modelEndpoint()).add("ModelSource", (Object)this.modelSourceAsString()).add("InvokeModelEndpointRoleArn", (Object)this.invokeModelEndpointRoleArn()).add("InputConfiguration", (Object)this.inputConfiguration()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("ModelEndpointStatus", (Object)this.modelEndpointStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelEndpoint": {
                return Optional.ofNullable(clazz.cast(this.modelEndpoint()));
            }
            case "modelSource": {
                return Optional.ofNullable(clazz.cast(this.modelSourceAsString()));
            }
            case "invokeModelEndpointRoleArn": {
                return Optional.ofNullable(clazz.cast(this.invokeModelEndpointRoleArn()));
            }
            case "inputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputConfiguration()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "modelEndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.modelEndpointStatusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutExternalModelRequest, T> g) {
        return obj -> g.apply((PutExternalModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String modelEndpoint;
        private String modelSource;
        private String invokeModelEndpointRoleArn;
        private ModelInputConfiguration inputConfiguration;
        private ModelOutputConfiguration outputConfiguration;
        private String modelEndpointStatus;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutExternalModelRequest model) {
            super(model);
            this.modelEndpoint(model.modelEndpoint);
            this.modelSource(model.modelSource);
            this.invokeModelEndpointRoleArn(model.invokeModelEndpointRoleArn);
            this.inputConfiguration(model.inputConfiguration);
            this.outputConfiguration(model.outputConfiguration);
            this.modelEndpointStatus(model.modelEndpointStatus);
            this.tags(model.tags);
        }

        public final String getModelEndpoint() {
            return this.modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        public final String getModelSource() {
            return this.modelSource;
        }

        @Override
        public final Builder modelSource(String modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        @Override
        public final Builder modelSource(ModelSource modelSource) {
            this.modelSource(modelSource == null ? null : modelSource.toString());
            return this;
        }

        public final void setModelSource(String modelSource) {
            this.modelSource = modelSource;
        }

        public final String getInvokeModelEndpointRoleArn() {
            return this.invokeModelEndpointRoleArn;
        }

        @Override
        public final Builder invokeModelEndpointRoleArn(String invokeModelEndpointRoleArn) {
            this.invokeModelEndpointRoleArn = invokeModelEndpointRoleArn;
            return this;
        }

        public final void setInvokeModelEndpointRoleArn(String invokeModelEndpointRoleArn) {
            this.invokeModelEndpointRoleArn = invokeModelEndpointRoleArn;
        }

        public final ModelInputConfiguration.Builder getInputConfiguration() {
            return this.inputConfiguration != null ? this.inputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputConfiguration(ModelInputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final void setInputConfiguration(ModelInputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        public final ModelOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder outputConfiguration(ModelOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final void setOutputConfiguration(ModelOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        public final String getModelEndpointStatus() {
            return this.modelEndpointStatus;
        }

        @Override
        public final Builder modelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
            return this;
        }

        @Override
        public final Builder modelEndpointStatus(ModelEndpointStatus modelEndpointStatus) {
            this.modelEndpointStatus(modelEndpointStatus == null ? null : modelEndpointStatus.toString());
            return this;
        }

        public final void setModelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutExternalModelRequest build() {
            return new PutExternalModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutExternalModelRequest> {
        public Builder modelEndpoint(String var1);

        public Builder modelSource(String var1);

        public Builder modelSource(ModelSource var1);

        public Builder invokeModelEndpointRoleArn(String var1);

        public Builder inputConfiguration(ModelInputConfiguration var1);

        default public Builder inputConfiguration(Consumer<ModelInputConfiguration.Builder> inputConfiguration) {
            return this.inputConfiguration((ModelInputConfiguration)((ModelInputConfiguration.Builder)ModelInputConfiguration.builder().applyMutation(inputConfiguration)).build());
        }

        public Builder outputConfiguration(ModelOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<ModelOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((ModelOutputConfiguration)((ModelOutputConfiguration.Builder)ModelOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder modelEndpointStatus(String var1);

        public Builder modelEndpointStatus(ModelEndpointStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

