/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ListOfModelVersionsCopier;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelVersion;
import software.amazon.awssdk.services.frauddetector.model.Rule;
import software.amazon.awssdk.services.frauddetector.model.RuleExecutionMode;
import software.amazon.awssdk.services.frauddetector.model.RuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDetectorVersionRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, UpdateDetectorVersionRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(UpdateDetectorVersionRequest.getter(UpdateDetectorVersionRequest::detectorId)).setter(UpdateDetectorVersionRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersionId").getter(UpdateDetectorVersionRequest.getter(UpdateDetectorVersionRequest::detectorVersionId)).setter(UpdateDetectorVersionRequest.setter(Builder::detectorVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()}).build();
    private static final SdkField<List<String>> EXTERNAL_MODEL_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("externalModelEndpoints").getter(UpdateDetectorVersionRequest.getter(UpdateDetectorVersionRequest::externalModelEndpoints)).setter(UpdateDetectorVersionRequest.setter(Builder::externalModelEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(UpdateDetectorVersionRequest.getter(UpdateDetectorVersionRequest::rules)).setter(UpdateDetectorVersionRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDetectorVersionRequest.getter(UpdateDetectorVersionRequest::description)).setter(UpdateDetectorVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<ModelVersion>> MODEL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelVersions").getter(UpdateDetectorVersionRequest.getter(UpdateDetectorVersionRequest::modelVersions)).setter(UpdateDetectorVersionRequest.setter(Builder::modelVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleExecutionMode").getter(UpdateDetectorVersionRequest.getter(UpdateDetectorVersionRequest::ruleExecutionModeAsString)).setter(UpdateDetectorVersionRequest.setter(Builder::ruleExecutionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, EXTERNAL_MODEL_ENDPOINTS_FIELD, RULES_FIELD, DESCRIPTION_FIELD, MODEL_VERSIONS_FIELD, RULE_EXECUTION_MODE_FIELD));
    private final String detectorId;
    private final String detectorVersionId;
    private final List<String> externalModelEndpoints;
    private final List<Rule> rules;
    private final String description;
    private final List<ModelVersion> modelVersions;
    private final String ruleExecutionMode;

    private UpdateDetectorVersionRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.externalModelEndpoints = builder.externalModelEndpoints;
        this.rules = builder.rules;
        this.description = builder.description;
        this.modelVersions = builder.modelVersions;
        this.ruleExecutionMode = builder.ruleExecutionMode;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String detectorVersionId() {
        return this.detectorVersionId;
    }

    public boolean hasExternalModelEndpoints() {
        return this.externalModelEndpoints != null && !(this.externalModelEndpoints instanceof SdkAutoConstructList);
    }

    public List<String> externalModelEndpoints() {
        return this.externalModelEndpoints;
    }

    public boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public String description() {
        return this.description;
    }

    public boolean hasModelVersions() {
        return this.modelVersions != null && !(this.modelVersions instanceof SdkAutoConstructList);
    }

    public List<ModelVersion> modelVersions() {
        return this.modelVersions;
    }

    public RuleExecutionMode ruleExecutionMode() {
        return RuleExecutionMode.fromValue(this.ruleExecutionMode);
    }

    public String ruleExecutionModeAsString() {
        return this.ruleExecutionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalModelEndpoints() ? this.externalModelEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVersions() ? this.modelVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleExecutionModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorVersionRequest)) {
            return false;
        }
        UpdateDetectorVersionRequest other = (UpdateDetectorVersionRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionId(), other.detectorVersionId()) && this.hasExternalModelEndpoints() == other.hasExternalModelEndpoints() && Objects.equals(this.externalModelEndpoints(), other.externalModelEndpoints()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.description(), other.description()) && this.hasModelVersions() == other.hasModelVersions() && Objects.equals(this.modelVersions(), other.modelVersions()) && Objects.equals(this.ruleExecutionModeAsString(), other.ruleExecutionModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDetectorVersionRequest").add("DetectorId", (Object)this.detectorId()).add("DetectorVersionId", (Object)this.detectorVersionId()).add("ExternalModelEndpoints", this.hasExternalModelEndpoints() ? this.externalModelEndpoints() : null).add("Rules", this.hasRules() ? this.rules() : null).add("Description", (Object)this.description()).add("ModelVersions", this.hasModelVersions() ? this.modelVersions() : null).add("RuleExecutionMode", (Object)this.ruleExecutionModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionId": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionId()));
            }
            case "externalModelEndpoints": {
                return Optional.ofNullable(clazz.cast(this.externalModelEndpoints()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "modelVersions": {
                return Optional.ofNullable(clazz.cast(this.modelVersions()));
            }
            case "ruleExecutionMode": {
                return Optional.ofNullable(clazz.cast(this.ruleExecutionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorVersionRequest, T> g) {
        return obj -> g.apply((UpdateDetectorVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String detectorVersionId;
        private List<String> externalModelEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<ModelVersion> modelVersions = DefaultSdkAutoConstructList.getInstance();
        private String ruleExecutionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorVersionRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.detectorVersionId(model.detectorVersionId);
            this.externalModelEndpoints(model.externalModelEndpoints);
            this.rules(model.rules);
            this.description(model.description);
            this.modelVersions(model.modelVersions);
            this.ruleExecutionMode(model.ruleExecutionMode);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDetectorVersionId() {
            return this.detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        public final Collection<String> getExternalModelEndpoints() {
            if (this.externalModelEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.externalModelEndpoints;
        }

        @Override
        public final Builder externalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalModelEndpoints(String ... externalModelEndpoints) {
            this.externalModelEndpoints(Arrays.asList(externalModelEndpoints));
            return this;
        }

        public final void setExternalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
        }

        public final Collection<Rule.Builder> getRules() {
            if (this.rules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rules != null ? (Collection)this.rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ModelVersion.Builder> getModelVersions() {
            if (this.modelVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.modelVersions != null ? (Collection)this.modelVersions.stream().map(ModelVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modelVersions(Collection<ModelVersion> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copy(modelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(ModelVersion ... modelVersions) {
            this.modelVersions(Arrays.asList(modelVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(Consumer<ModelVersion.Builder> ... modelVersions) {
            this.modelVersions(Stream.of(modelVersions).map(c -> (ModelVersion)((ModelVersion.Builder)ModelVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModelVersions(Collection<ModelVersion.BuilderImpl> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copyFromBuilder(modelVersions);
        }

        public final String getRuleExecutionMode() {
            return this.ruleExecutionMode;
        }

        @Override
        public final Builder ruleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
            return this;
        }

        @Override
        public final Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode) {
            this.ruleExecutionMode(ruleExecutionMode == null ? null : ruleExecutionMode.toString());
            return this;
        }

        public final void setRuleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDetectorVersionRequest build() {
            return new UpdateDetectorVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDetectorVersionRequest> {
        public Builder detectorId(String var1);

        public Builder detectorVersionId(String var1);

        public Builder externalModelEndpoints(Collection<String> var1);

        public Builder externalModelEndpoints(String ... var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder description(String var1);

        public Builder modelVersions(Collection<ModelVersion> var1);

        public Builder modelVersions(ModelVersion ... var1);

        public Builder modelVersions(Consumer<ModelVersion.Builder> ... var1);

        public Builder ruleExecutionMode(String var1);

        public Builder ruleExecutionMode(RuleExecutionMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

