/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.ConflictException;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorException;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetPredictionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetPredictionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetRulesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetRulesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse;
import software.amazon.awssdk.services.frauddetector.model.InternalServerException;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutModelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutModelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.ResourceNotFoundException;
import software.amazon.awssdk.services.frauddetector.model.ThrottlingException;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.ValidationException;
import software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetModelsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetRulesIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetVariablesIterable;
import software.amazon.awssdk.services.frauddetector.transform.BatchCreateVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.BatchGetVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEventRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteRuleVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DescribeDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DescribeModelVersionsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetDetectorsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetExternalModelsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetModelsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetOutcomesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetPredictionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetRulesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetVariablesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutExternalModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutOutcomeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionStatusRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateRuleMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateRuleVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateVariableRequestMarshaller;

@SdkInternalApi
final class DefaultFraudDetectorClient
implements FraudDetectorClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultFraudDetectorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "frauddetector";
    }

    @Override
    public BatchCreateVariableResponse batchCreateVariable(BatchCreateVariableRequest batchCreateVariableRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreateVariableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchCreateVariableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreateVariable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchCreateVariableRequest).withMarshaller((Marshaller)new BatchCreateVariableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchGetVariableResponse batchGetVariable(BatchGetVariableRequest batchGetVariableRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetVariableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchGetVariableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetVariable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetVariableRequest).withMarshaller((Marshaller)new BatchGetVariableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDetectorVersionResponse createDetectorVersion(CreateDetectorVersionRequest createDetectorVersionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDetectorVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDetectorVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDetectorVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDetectorVersionRequest).withMarshaller((Marshaller)new CreateDetectorVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateModelVersionResponse createModelVersion(CreateModelVersionRequest createModelVersionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateModelVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateModelVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateModelVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createModelVersionRequest).withMarshaller((Marshaller)new CreateModelVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRuleRequest).withMarshaller((Marshaller)new CreateRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateVariableResponse createVariable(CreateVariableRequest createVariableRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVariableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateVariableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVariable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVariableRequest).withMarshaller((Marshaller)new CreateVariableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDetectorResponse deleteDetector(DeleteDetectorRequest deleteDetectorRequest) throws ConflictException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDetectorRequest).withMarshaller((Marshaller)new DeleteDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDetectorVersionResponse deleteDetectorVersion(DeleteDetectorVersionRequest deleteDetectorVersionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDetectorVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDetectorVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDetectorVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDetectorVersionRequest).withMarshaller((Marshaller)new DeleteDetectorVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteEventResponse deleteEvent(DeleteEventRequest deleteEventRequest) throws InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteEventResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEvent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventRequest).withMarshaller((Marshaller)new DeleteEventRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteRuleVersionResponse deleteRuleVersion(DeleteRuleVersionRequest deleteRuleVersionRequest) throws ConflictException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteRuleVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRuleVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleVersionRequest).withMarshaller((Marshaller)new DeleteRuleVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDetectorResponse describeDetector(DescribeDetectorRequest describeDetectorRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDetectorRequest).withMarshaller((Marshaller)new DescribeDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeModelVersionsResponse describeModelVersions(DescribeModelVersionsRequest describeModelVersionsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeModelVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeModelVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeModelVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeModelVersionsRequest).withMarshaller((Marshaller)new DescribeModelVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeModelVersionsIterable describeModelVersionsPaginator(DescribeModelVersionsRequest describeModelVersionsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        return new DescribeModelVersionsIterable(this, this.applyPaginatorUserAgent(describeModelVersionsRequest));
    }

    @Override
    public GetDetectorVersionResponse getDetectorVersion(GetDetectorVersionRequest getDetectorVersionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDetectorVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDetectorVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDetectorVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDetectorVersionRequest).withMarshaller((Marshaller)new GetDetectorVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDetectorsResponse getDetectors(GetDetectorsRequest getDetectorsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDetectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDetectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDetectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDetectorsRequest).withMarshaller((Marshaller)new GetDetectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDetectorsIterable getDetectorsPaginator(GetDetectorsRequest getDetectorsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        return new GetDetectorsIterable(this, this.applyPaginatorUserAgent(getDetectorsRequest));
    }

    @Override
    public GetExternalModelsResponse getExternalModels(GetExternalModelsRequest getExternalModelsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExternalModelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetExternalModelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExternalModels").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getExternalModelsRequest).withMarshaller((Marshaller)new GetExternalModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetExternalModelsIterable getExternalModelsPaginator(GetExternalModelsRequest getExternalModelsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        return new GetExternalModelsIterable(this, this.applyPaginatorUserAgent(getExternalModelsRequest));
    }

    @Override
    public GetModelVersionResponse getModelVersion(GetModelVersionRequest getModelVersionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetModelVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetModelVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetModelVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getModelVersionRequest).withMarshaller((Marshaller)new GetModelVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetModelsResponse getModels(GetModelsRequest getModelsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetModelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetModelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetModels").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getModelsRequest).withMarshaller((Marshaller)new GetModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetModelsIterable getModelsPaginator(GetModelsRequest getModelsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        return new GetModelsIterable(this, this.applyPaginatorUserAgent(getModelsRequest));
    }

    @Override
    public GetOutcomesResponse getOutcomes(GetOutcomesRequest getOutcomesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOutcomesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetOutcomesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOutcomes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getOutcomesRequest).withMarshaller((Marshaller)new GetOutcomesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetOutcomesIterable getOutcomesPaginator(GetOutcomesRequest getOutcomesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        return new GetOutcomesIterable(this, this.applyPaginatorUserAgent(getOutcomesRequest));
    }

    @Override
    public GetPredictionResponse getPrediction(GetPredictionRequest getPredictionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPredictionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPredictionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPrediction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPredictionRequest).withMarshaller((Marshaller)new GetPredictionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetRulesResponse getRules(GetRulesRequest getRulesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRulesRequest).withMarshaller((Marshaller)new GetRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetRulesIterable getRulesPaginator(GetRulesRequest getRulesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        return new GetRulesIterable(this, this.applyPaginatorUserAgent(getRulesRequest));
    }

    @Override
    public GetVariablesResponse getVariables(GetVariablesRequest getVariablesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVariablesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetVariablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVariables").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVariablesRequest).withMarshaller((Marshaller)new GetVariablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetVariablesIterable getVariablesPaginator(GetVariablesRequest getVariablesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        return new GetVariablesIterable(this, this.applyPaginatorUserAgent(getVariablesRequest));
    }

    @Override
    public PutDetectorResponse putDetector(PutDetectorRequest putDetectorRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDetectorRequest).withMarshaller((Marshaller)new PutDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutExternalModelResponse putExternalModel(PutExternalModelRequest putExternalModelRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutExternalModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutExternalModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutExternalModel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putExternalModelRequest).withMarshaller((Marshaller)new PutExternalModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutModelResponse putModel(PutModelRequest putModelRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutModel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putModelRequest).withMarshaller((Marshaller)new PutModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutOutcomeResponse putOutcome(PutOutcomeRequest putOutcomeRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutOutcomeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutOutcomeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutOutcome").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putOutcomeRequest).withMarshaller((Marshaller)new PutOutcomeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDetectorVersionResponse updateDetectorVersion(UpdateDetectorVersionRequest updateDetectorVersionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDetectorVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDetectorVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDetectorVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDetectorVersionRequest).withMarshaller((Marshaller)new UpdateDetectorVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDetectorVersionMetadataResponse updateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest updateDetectorVersionMetadataRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDetectorVersionMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDetectorVersionMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDetectorVersionMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDetectorVersionMetadataRequest).withMarshaller((Marshaller)new UpdateDetectorVersionMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDetectorVersionStatusResponse updateDetectorVersionStatus(UpdateDetectorVersionStatusRequest updateDetectorVersionStatusRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDetectorVersionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDetectorVersionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDetectorVersionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDetectorVersionStatusRequest).withMarshaller((Marshaller)new UpdateDetectorVersionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateModelVersionResponse updateModelVersion(UpdateModelVersionRequest updateModelVersionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateModelVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateModelVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateModelVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateModelVersionRequest).withMarshaller((Marshaller)new UpdateModelVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateRuleMetadataResponse updateRuleMetadata(UpdateRuleMetadataRequest updateRuleMetadataRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuleMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateRuleMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRuleMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRuleMetadataRequest).withMarshaller((Marshaller)new UpdateRuleMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateRuleVersionResponse updateRuleVersion(UpdateRuleVersionRequest updateRuleVersionRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuleVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateRuleVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRuleVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRuleVersionRequest).withMarshaller((Marshaller)new UpdateRuleVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateVariableResponse updateVariable(UpdateVariableRequest updateVariableRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVariableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateVariableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVariable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateVariableRequest).withMarshaller((Marshaller)new UpdateVariableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(FraudDetectorException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends FraudDetectorRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.9").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((FraudDetectorRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

