/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.ModelEndpointStatus;
import software.amazon.awssdk.services.frauddetector.model.ModelInputConfiguration;
import software.amazon.awssdk.services.frauddetector.model.ModelOutputConfiguration;
import software.amazon.awssdk.services.frauddetector.model.ModelSource;
import software.amazon.awssdk.services.frauddetector.model.Role;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalModel> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExternalModel.getter(ExternalModel::modelEndpoint)).setter(ExternalModel.setter(Builder::modelEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExternalModel.getter(ExternalModel::eventTypeName)).setter(ExternalModel.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> MODEL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExternalModel.getter(ExternalModel::modelSourceAsString)).setter(ExternalModel.setter(Builder::modelSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()}).build();
    private static final SdkField<Role> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExternalModel.getter(ExternalModel::role)).setter(ExternalModel.setter(Builder::role)).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<ModelInputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExternalModel.getter(ExternalModel::inputConfiguration)).setter(ExternalModel.setter(Builder::inputConfiguration)).constructor(ModelInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build()}).build();
    private static final SdkField<ModelOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExternalModel.getter(ExternalModel::outputConfiguration)).setter(ExternalModel.setter(Builder::outputConfiguration)).constructor(ModelOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<String> MODEL_ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExternalModel.getter(ExternalModel::modelEndpointStatusAsString)).setter(ExternalModel.setter(Builder::modelEndpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpointStatus").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExternalModel.getter(ExternalModel::lastUpdatedTime)).setter(ExternalModel.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExternalModel.getter(ExternalModel::createdTime)).setter(ExternalModel.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExternalModel.getter(ExternalModel::arn)).setter(ExternalModel.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD, EVENT_TYPE_NAME_FIELD, MODEL_SOURCE_FIELD, ROLE_FIELD, INPUT_CONFIGURATION_FIELD, OUTPUT_CONFIGURATION_FIELD, MODEL_ENDPOINT_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelEndpoint;
    private final String eventTypeName;
    private final String modelSource;
    private final Role role;
    private final ModelInputConfiguration inputConfiguration;
    private final ModelOutputConfiguration outputConfiguration;
    private final String modelEndpointStatus;
    private final String lastUpdatedTime;
    private final String createdTime;
    private final String arn;

    private ExternalModel(BuilderImpl builder) {
        this.modelEndpoint = builder.modelEndpoint;
        this.eventTypeName = builder.eventTypeName;
        this.modelSource = builder.modelSource;
        this.role = builder.role;
        this.inputConfiguration = builder.inputConfiguration;
        this.outputConfiguration = builder.outputConfiguration;
        this.modelEndpointStatus = builder.modelEndpointStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    public String modelEndpoint() {
        return this.modelEndpoint;
    }

    public String eventTypeName() {
        return this.eventTypeName;
    }

    public ModelSource modelSource() {
        return ModelSource.fromValue(this.modelSource);
    }

    public String modelSourceAsString() {
        return this.modelSource;
    }

    public Role role() {
        return this.role;
    }

    public ModelInputConfiguration inputConfiguration() {
        return this.inputConfiguration;
    }

    public ModelOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public ModelEndpointStatus modelEndpointStatus() {
        return ModelEndpointStatus.fromValue(this.modelEndpointStatus);
    }

    public String modelEndpointStatusAsString() {
        return this.modelEndpointStatus;
    }

    public String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String createdTime() {
        return this.createdTime;
    }

    public String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalModel)) {
            return false;
        }
        ExternalModel other = (ExternalModel)obj;
        return Objects.equals(this.modelEndpoint(), other.modelEndpoint()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.modelSourceAsString(), other.modelSourceAsString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.inputConfiguration(), other.inputConfiguration()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.modelEndpointStatusAsString(), other.modelEndpointStatusAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.arn(), other.arn());
    }

    public String toString() {
        return ToString.builder((String)"ExternalModel").add("ModelEndpoint", (Object)this.modelEndpoint()).add("EventTypeName", (Object)this.eventTypeName()).add("ModelSource", (Object)this.modelSourceAsString()).add("Role", (Object)this.role()).add("InputConfiguration", (Object)this.inputConfiguration()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("ModelEndpointStatus", (Object)this.modelEndpointStatusAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).add("Arn", (Object)this.arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelEndpoint": {
                return Optional.ofNullable(clazz.cast(this.modelEndpoint()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "modelSource": {
                return Optional.ofNullable(clazz.cast(this.modelSourceAsString()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "inputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputConfiguration()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "modelEndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.modelEndpointStatusAsString()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalModel, T> g) {
        return obj -> g.apply((ExternalModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelEndpoint;
        private String eventTypeName;
        private String modelSource;
        private Role role;
        private ModelInputConfiguration inputConfiguration;
        private ModelOutputConfiguration outputConfiguration;
        private String modelEndpointStatus;
        private String lastUpdatedTime;
        private String createdTime;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalModel model) {
            this.modelEndpoint(model.modelEndpoint);
            this.eventTypeName(model.eventTypeName);
            this.modelSource(model.modelSource);
            this.role(model.role);
            this.inputConfiguration(model.inputConfiguration);
            this.outputConfiguration(model.outputConfiguration);
            this.modelEndpointStatus(model.modelEndpointStatus);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
            this.arn(model.arn);
        }

        public final String getModelEndpoint() {
            return this.modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        public final String getModelSource() {
            return this.modelSource;
        }

        @Override
        public final Builder modelSource(String modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        @Override
        public final Builder modelSource(ModelSource modelSource) {
            this.modelSource(modelSource == null ? null : modelSource.toString());
            return this;
        }

        public final void setModelSource(String modelSource) {
            this.modelSource = modelSource;
        }

        public final Role.Builder getRole() {
            return this.role != null ? this.role.toBuilder() : null;
        }

        @Override
        public final Builder role(Role role) {
            this.role = role;
            return this;
        }

        public final void setRole(Role.BuilderImpl role) {
            this.role = role != null ? role.build() : null;
        }

        public final ModelInputConfiguration.Builder getInputConfiguration() {
            return this.inputConfiguration != null ? this.inputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputConfiguration(ModelInputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final void setInputConfiguration(ModelInputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        public final ModelOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder outputConfiguration(ModelOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final void setOutputConfiguration(ModelOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        public final String getModelEndpointStatus() {
            return this.modelEndpointStatus;
        }

        @Override
        public final Builder modelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
            return this;
        }

        @Override
        public final Builder modelEndpointStatus(ModelEndpointStatus modelEndpointStatus) {
            this.modelEndpointStatus(modelEndpointStatus == null ? null : modelEndpointStatus.toString());
            return this;
        }

        public final void setModelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public ExternalModel build() {
            return new ExternalModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalModel> {
        public Builder modelEndpoint(String var1);

        public Builder eventTypeName(String var1);

        public Builder modelSource(String var1);

        public Builder modelSource(ModelSource var1);

        public Builder role(Role var1);

        default public Builder role(Consumer<Role.Builder> role) {
            return this.role((Role)((Role.Builder)Role.builder().applyMutation(role)).build());
        }

        public Builder inputConfiguration(ModelInputConfiguration var1);

        default public Builder inputConfiguration(Consumer<ModelInputConfiguration.Builder> inputConfiguration) {
            return this.inputConfiguration((ModelInputConfiguration)((ModelInputConfiguration.Builder)ModelInputConfiguration.builder().applyMutation(inputConfiguration)).build());
        }

        public Builder outputConfiguration(ModelOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<ModelOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((ModelOutputConfiguration)((ModelOutputConfiguration.Builder)ModelOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder modelEndpointStatus(String var1);

        public Builder modelEndpointStatus(ModelEndpointStatus var1);

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);

        public Builder arn(String var1);
    }
}

