/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.EventAttributeMapCopier;
import software.amazon.awssdk.services.frauddetector.model.ExternalModelEndpointDataBlobMapCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ModelEndpointDataBlob;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPredictionRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, GetPredictionRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPredictionRequest.getter(GetPredictionRequest::detectorId)).setter(GetPredictionRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPredictionRequest.getter(GetPredictionRequest::detectorVersionId)).setter(GetPredictionRequest.setter(Builder::detectorVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPredictionRequest.getter(GetPredictionRequest::eventId)).setter(GetPredictionRequest.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<Map<String, String>> EVENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetPredictionRequest.getter(GetPredictionRequest::eventAttributes)).setter(GetPredictionRequest.setter(Builder::eventAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ModelEndpointDataBlob>> EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetPredictionRequest.getter(GetPredictionRequest::externalModelEndpointDataBlobs)).setter(GetPredictionRequest.setter(Builder::externalModelEndpointDataBlobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpointDataBlobs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelEndpointDataBlob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, EVENT_ID_FIELD, EVENT_ATTRIBUTES_FIELD, EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD));
    private final String detectorId;
    private final String detectorVersionId;
    private final String eventId;
    private final Map<String, String> eventAttributes;
    private final Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs;

    private GetPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.eventId = builder.eventId;
        this.eventAttributes = builder.eventAttributes;
        this.externalModelEndpointDataBlobs = builder.externalModelEndpointDataBlobs;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String detectorVersionId() {
        return this.detectorVersionId;
    }

    public String eventId() {
        return this.eventId;
    }

    public boolean hasEventAttributes() {
        return this.eventAttributes != null && !(this.eventAttributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> eventAttributes() {
        return this.eventAttributes;
    }

    public boolean hasExternalModelEndpointDataBlobs() {
        return this.externalModelEndpointDataBlobs != null && !(this.externalModelEndpointDataBlobs instanceof SdkAutoConstructMap);
    }

    public Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs() {
        return this.externalModelEndpointDataBlobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalModelEndpointDataBlobs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPredictionRequest)) {
            return false;
        }
        GetPredictionRequest other = (GetPredictionRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionId(), other.detectorVersionId()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventAttributes(), other.eventAttributes()) && Objects.equals(this.externalModelEndpointDataBlobs(), other.externalModelEndpointDataBlobs());
    }

    public String toString() {
        return ToString.builder((String)"GetPredictionRequest").add("DetectorId", (Object)this.detectorId()).add("DetectorVersionId", (Object)this.detectorVersionId()).add("EventId", (Object)this.eventId()).add("EventAttributes", (Object)(this.eventAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("ExternalModelEndpointDataBlobs", (Object)(this.externalModelEndpointDataBlobs() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionId": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionId()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventAttributes": {
                return Optional.ofNullable(clazz.cast(this.eventAttributes()));
            }
            case "externalModelEndpointDataBlobs": {
                return Optional.ofNullable(clazz.cast(this.externalModelEndpointDataBlobs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPredictionRequest, T> g) {
        return obj -> g.apply((GetPredictionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String detectorVersionId;
        private String eventId;
        private Map<String, String> eventAttributes = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPredictionRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.detectorVersionId(model.detectorVersionId);
            this.eventId(model.eventId);
            this.eventAttributes(model.eventAttributes);
            this.externalModelEndpointDataBlobs(model.externalModelEndpointDataBlobs);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDetectorVersionId() {
            return this.detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final Map<String, String> getEventAttributes() {
            return this.eventAttributes;
        }

        @Override
        public final Builder eventAttributes(Map<String, String> eventAttributes) {
            this.eventAttributes = EventAttributeMapCopier.copy(eventAttributes);
            return this;
        }

        public final void setEventAttributes(Map<String, String> eventAttributes) {
            this.eventAttributes = EventAttributeMapCopier.copy(eventAttributes);
        }

        public final Map<String, ModelEndpointDataBlob.Builder> getExternalModelEndpointDataBlobs() {
            return this.externalModelEndpointDataBlobs != null ? CollectionUtils.mapValues(this.externalModelEndpointDataBlobs, ModelEndpointDataBlob::toBuilder) : null;
        }

        @Override
        public final Builder externalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = ExternalModelEndpointDataBlobMapCopier.copy(externalModelEndpointDataBlobs);
            return this;
        }

        public final void setExternalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob.BuilderImpl> externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = ExternalModelEndpointDataBlobMapCopier.copyFromBuilder(externalModelEndpointDataBlobs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPredictionRequest build() {
            return new GetPredictionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPredictionRequest> {
        public Builder detectorId(String var1);

        public Builder detectorVersionId(String var1);

        public Builder eventId(String var1);

        public Builder eventAttributes(Map<String, String> var1);

        public Builder externalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

