/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.VariableEntry;
import software.amazon.awssdk.services.frauddetector.model.VariableEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateVariableRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, BatchCreateVariableRequest> {
    private static final SdkField<List<VariableEntry>> VARIABLE_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchCreateVariableRequest.getter(BatchCreateVariableRequest::variableEntries)).setter(BatchCreateVariableRequest.setter(Builder::variableEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariableEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_ENTRIES_FIELD));
    private final List<VariableEntry> variableEntries;

    private BatchCreateVariableRequest(BuilderImpl builder) {
        super(builder);
        this.variableEntries = builder.variableEntries;
    }

    public boolean hasVariableEntries() {
        return this.variableEntries != null && !(this.variableEntries instanceof SdkAutoConstructList);
    }

    public List<VariableEntry> variableEntries() {
        return this.variableEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.variableEntries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateVariableRequest)) {
            return false;
        }
        BatchCreateVariableRequest other = (BatchCreateVariableRequest)((Object)obj);
        return Objects.equals(this.variableEntries(), other.variableEntries());
    }

    public String toString() {
        return ToString.builder((String)"BatchCreateVariableRequest").add("VariableEntries", this.variableEntries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variableEntries": {
                return Optional.ofNullable(clazz.cast(this.variableEntries()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateVariableRequest, T> g) {
        return obj -> g.apply((BatchCreateVariableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private List<VariableEntry> variableEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateVariableRequest model) {
            super(model);
            this.variableEntries(model.variableEntries);
        }

        public final Collection<VariableEntry.Builder> getVariableEntries() {
            return this.variableEntries != null ? (Collection)this.variableEntries.stream().map(VariableEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder variableEntries(Collection<VariableEntry> variableEntries) {
            this.variableEntries = VariableEntryListCopier.copy(variableEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableEntries(VariableEntry ... variableEntries) {
            this.variableEntries(Arrays.asList(variableEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableEntries(Consumer<VariableEntry.Builder> ... variableEntries) {
            this.variableEntries(Stream.of(variableEntries).map(c -> (VariableEntry)((VariableEntry.Builder)VariableEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVariableEntries(Collection<VariableEntry.BuilderImpl> variableEntries) {
            this.variableEntries = VariableEntryListCopier.copyFromBuilder(variableEntries);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateVariableRequest build() {
            return new BatchCreateVariableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateVariableRequest> {
        public Builder variableEntries(Collection<VariableEntry> var1);

        public Builder variableEntries(VariableEntry ... var1);

        public Builder variableEntries(Consumer<VariableEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

