/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.ModelInputDataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelInputConfiguration> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelInputConfiguration.getter(ModelInputConfiguration::formatAsString)).setter(ModelInputConfiguration.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<Boolean> IS_OPAQUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModelInputConfiguration.getter(ModelInputConfiguration::isOpaque)).setter(ModelInputConfiguration.setter(Builder::isOpaque)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isOpaque").build()}).build();
    private static final SdkField<String> JSON_INPUT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelInputConfiguration.getter(ModelInputConfiguration::jsonInputTemplate)).setter(ModelInputConfiguration.setter(Builder::jsonInputTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonInputTemplate").build()}).build();
    private static final SdkField<String> CSV_INPUT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelInputConfiguration.getter(ModelInputConfiguration::csvInputTemplate)).setter(ModelInputConfiguration.setter(Builder::csvInputTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csvInputTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, IS_OPAQUE_FIELD, JSON_INPUT_TEMPLATE_FIELD, CSV_INPUT_TEMPLATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final Boolean isOpaque;
    private final String jsonInputTemplate;
    private final String csvInputTemplate;

    private ModelInputConfiguration(BuilderImpl builder) {
        this.format = builder.format;
        this.isOpaque = builder.isOpaque;
        this.jsonInputTemplate = builder.jsonInputTemplate;
        this.csvInputTemplate = builder.csvInputTemplate;
    }

    public ModelInputDataFormat format() {
        return ModelInputDataFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public Boolean isOpaque() {
        return this.isOpaque;
    }

    public String jsonInputTemplate() {
        return this.jsonInputTemplate;
    }

    public String csvInputTemplate() {
        return this.csvInputTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isOpaque());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonInputTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvInputTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInputConfiguration)) {
            return false;
        }
        ModelInputConfiguration other = (ModelInputConfiguration)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.isOpaque(), other.isOpaque()) && Objects.equals(this.jsonInputTemplate(), other.jsonInputTemplate()) && Objects.equals(this.csvInputTemplate(), other.csvInputTemplate());
    }

    public String toString() {
        return ToString.builder((String)"ModelInputConfiguration").add("Format", (Object)this.formatAsString()).add("IsOpaque", (Object)this.isOpaque()).add("JsonInputTemplate", (Object)this.jsonInputTemplate()).add("CsvInputTemplate", (Object)this.csvInputTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "isOpaque": {
                return Optional.ofNullable(clazz.cast(this.isOpaque()));
            }
            case "jsonInputTemplate": {
                return Optional.ofNullable(clazz.cast(this.jsonInputTemplate()));
            }
            case "csvInputTemplate": {
                return Optional.ofNullable(clazz.cast(this.csvInputTemplate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelInputConfiguration, T> g) {
        return obj -> g.apply((ModelInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private Boolean isOpaque;
        private String jsonInputTemplate;
        private String csvInputTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInputConfiguration model) {
            this.format(model.format);
            this.isOpaque(model.isOpaque);
            this.jsonInputTemplate(model.jsonInputTemplate);
            this.csvInputTemplate(model.csvInputTemplate);
        }

        public final String getFormatAsString() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ModelInputDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Boolean getIsOpaque() {
            return this.isOpaque;
        }

        @Override
        public final Builder isOpaque(Boolean isOpaque) {
            this.isOpaque = isOpaque;
            return this;
        }

        public final void setIsOpaque(Boolean isOpaque) {
            this.isOpaque = isOpaque;
        }

        public final String getJsonInputTemplate() {
            return this.jsonInputTemplate;
        }

        @Override
        public final Builder jsonInputTemplate(String jsonInputTemplate) {
            this.jsonInputTemplate = jsonInputTemplate;
            return this;
        }

        public final void setJsonInputTemplate(String jsonInputTemplate) {
            this.jsonInputTemplate = jsonInputTemplate;
        }

        public final String getCsvInputTemplate() {
            return this.csvInputTemplate;
        }

        @Override
        public final Builder csvInputTemplate(String csvInputTemplate) {
            this.csvInputTemplate = csvInputTemplate;
            return this;
        }

        public final void setCsvInputTemplate(String csvInputTemplate) {
            this.csvInputTemplate = csvInputTemplate;
        }

        public ModelInputConfiguration build() {
            return new ModelInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelInputConfiguration> {
        public Builder format(String var1);

        public Builder format(ModelInputDataFormat var1);

        public Builder isOpaque(Boolean var1);

        public Builder jsonInputTemplate(String var1);

        public Builder csvInputTemplate(String var1);
    }
}

