/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.Language;
import software.amazon.awssdk.services.frauddetector.model.NonEmptyListOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleDetail> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RuleDetail.getter(RuleDetail::ruleId)).setter(RuleDetail.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RuleDetail.getter(RuleDetail::description)).setter(RuleDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RuleDetail.getter(RuleDetail::detectorId)).setter(RuleDetail.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RuleDetail.getter(RuleDetail::ruleVersion)).setter(RuleDetail.setter(Builder::ruleVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleVersion").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RuleDetail.getter(RuleDetail::expression)).setter(RuleDetail.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RuleDetail.getter(RuleDetail::languageAsString)).setter(RuleDetail.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RuleDetail.getter(RuleDetail::outcomes)).setter(RuleDetail.setter(Builder::outcomes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RuleDetail.getter(RuleDetail::lastUpdatedTime)).setter(RuleDetail.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RuleDetail.getter(RuleDetail::createdTime)).setter(RuleDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD, DESCRIPTION_FIELD, DETECTOR_ID_FIELD, RULE_VERSION_FIELD, EXPRESSION_FIELD, LANGUAGE_FIELD, OUTCOMES_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleId;
    private final String description;
    private final String detectorId;
    private final String ruleVersion;
    private final String expression;
    private final String language;
    private final List<String> outcomes;
    private final String lastUpdatedTime;
    private final String createdTime;

    private RuleDetail(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.description = builder.description;
        this.detectorId = builder.detectorId;
        this.ruleVersion = builder.ruleVersion;
        this.expression = builder.expression;
        this.language = builder.language;
        this.outcomes = builder.outcomes;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String description() {
        return this.description;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String ruleVersion() {
        return this.ruleVersion;
    }

    public String expression() {
        return this.expression;
    }

    public Language language() {
        return Language.fromValue(this.language);
    }

    public String languageAsString() {
        return this.language;
    }

    public List<String> outcomes() {
        return this.outcomes;
    }

    public String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outcomes());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDetail)) {
            return false;
        }
        RuleDetail other = (RuleDetail)obj;
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.ruleVersion(), other.ruleVersion()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.languageAsString(), other.languageAsString()) && Objects.equals(this.outcomes(), other.outcomes()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public String toString() {
        return ToString.builder((String)"RuleDetail").add("RuleId", (Object)this.ruleId()).add("Description", (Object)this.description()).add("DetectorId", (Object)this.detectorId()).add("RuleVersion", (Object)this.ruleVersion()).add("Expression", (Object)this.expression()).add("Language", (Object)this.languageAsString()).add("Outcomes", this.outcomes()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "ruleVersion": {
                return Optional.ofNullable(clazz.cast(this.ruleVersion()));
            }
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "outcomes": {
                return Optional.ofNullable(clazz.cast(this.outcomes()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleDetail, T> g) {
        return obj -> g.apply((RuleDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String description;
        private String detectorId;
        private String ruleVersion;
        private String expression;
        private String language;
        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();
        private String lastUpdatedTime;
        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleDetail model) {
            this.ruleId(model.ruleId);
            this.description(model.description);
            this.detectorId(model.detectorId);
            this.ruleVersion(model.ruleVersion);
            this.expression(model.expression);
            this.language(model.language);
            this.outcomes(model.outcomes);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getRuleVersion() {
            return this.ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        public final String getExpression() {
            return this.expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public final String getLanguageAsString() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(Language language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final Collection<String> getOutcomes() {
            return this.outcomes;
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = NonEmptyListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String ... outcomes) {
            this.outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = NonEmptyListOfStringsCopier.copy(outcomes);
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public RuleDetail build() {
            return new RuleDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleDetail> {
        public Builder ruleId(String var1);

        public Builder description(String var1);

        public Builder detectorId(String var1);

        public Builder ruleVersion(String var1);

        public Builder expression(String var1);

        public Builder language(String var1);

        public Builder language(Language var1);

        public Builder outcomes(Collection<String> var1);

        public Builder outcomes(String ... var1);

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);
    }
}

