/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.ModelVersionDetail;
import software.amazon.awssdk.services.frauddetector.model.ModelVersionDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelVersionsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, DescribeModelVersionsResponse> {
    private static final SdkField<List<ModelVersionDetail>> MODEL_VERSION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeModelVersionsResponse.getter(DescribeModelVersionsResponse::modelVersionDetails)).setter(DescribeModelVersionsResponse.setter(Builder::modelVersionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVersionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeModelVersionsResponse.getter(DescribeModelVersionsResponse::nextToken)).setter(DescribeModelVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VERSION_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ModelVersionDetail> modelVersionDetails;
    private final String nextToken;

    private DescribeModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.modelVersionDetails = builder.modelVersionDetails;
        this.nextToken = builder.nextToken;
    }

    public List<ModelVersionDetail> modelVersionDetails() {
        return this.modelVersionDetails;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelVersionsResponse)) {
            return false;
        }
        DescribeModelVersionsResponse other = (DescribeModelVersionsResponse)((Object)obj);
        return Objects.equals(this.modelVersionDetails(), other.modelVersionDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeModelVersionsResponse").add("ModelVersionDetails", this.modelVersionDetails()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelVersionDetails": {
                return Optional.ofNullable(clazz.cast(this.modelVersionDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelVersionsResponse, T> g) {
        return obj -> g.apply((DescribeModelVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<ModelVersionDetail> modelVersionDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelVersionsResponse model) {
            super(model);
            this.modelVersionDetails(model.modelVersionDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<ModelVersionDetail.Builder> getModelVersionDetails() {
            return this.modelVersionDetails != null ? (Collection)this.modelVersionDetails.stream().map(ModelVersionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modelVersionDetails(Collection<ModelVersionDetail> modelVersionDetails) {
            this.modelVersionDetails = ModelVersionDetailListCopier.copy(modelVersionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionDetails(ModelVersionDetail ... modelVersionDetails) {
            this.modelVersionDetails(Arrays.asList(modelVersionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionDetails(Consumer<ModelVersionDetail.Builder> ... modelVersionDetails) {
            this.modelVersionDetails(Stream.of(modelVersionDetails).map(c -> (ModelVersionDetail)((ModelVersionDetail.Builder)ModelVersionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModelVersionDetails(Collection<ModelVersionDetail.BuilderImpl> modelVersionDetails) {
            this.modelVersionDetails = ModelVersionDetailListCopier.copyFromBuilder(modelVersionDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeModelVersionsResponse build() {
            return new DescribeModelVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelVersionsResponse> {
        public Builder modelVersionDetails(Collection<ModelVersionDetail> var1);

        public Builder modelVersionDetails(ModelVersionDetail ... var1);

        public Builder modelVersionDetails(Consumer<ModelVersionDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

