/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.LabelMapperCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelSchema> {
    private static final SdkField<String> LABEL_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LabelSchema.getter(LabelSchema::labelKey)).setter(LabelSchema.setter(Builder::labelKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelKey").build()}).build();
    private static final SdkField<Map<String, List<String>>> LABEL_MAPPER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(LabelSchema.getter(LabelSchema::labelMapper)).setter(LabelSchema.setter(Builder::labelMapper)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelMapper").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_KEY_FIELD, LABEL_MAPPER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String labelKey;
    private final Map<String, List<String>> labelMapper;

    private LabelSchema(BuilderImpl builder) {
        this.labelKey = builder.labelKey;
        this.labelMapper = builder.labelMapper;
    }

    public String labelKey() {
        return this.labelKey;
    }

    public Map<String, List<String>> labelMapper() {
        return this.labelMapper;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labelKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelMapper());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelSchema)) {
            return false;
        }
        LabelSchema other = (LabelSchema)obj;
        return Objects.equals(this.labelKey(), other.labelKey()) && Objects.equals(this.labelMapper(), other.labelMapper());
    }

    public String toString() {
        return ToString.builder((String)"LabelSchema").add("LabelKey", (Object)this.labelKey()).add("LabelMapper", this.labelMapper()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "labelKey": {
                return Optional.ofNullable(clazz.cast(this.labelKey()));
            }
            case "labelMapper": {
                return Optional.ofNullable(clazz.cast(this.labelMapper()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelSchema, T> g) {
        return obj -> g.apply((LabelSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String labelKey;
        private Map<String, List<String>> labelMapper = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LabelSchema model) {
            this.labelKey(model.labelKey);
            this.labelMapper(model.labelMapper);
        }

        public final String getLabelKey() {
            return this.labelKey;
        }

        @Override
        public final Builder labelKey(String labelKey) {
            this.labelKey = labelKey;
            return this;
        }

        public final void setLabelKey(String labelKey) {
            this.labelKey = labelKey;
        }

        public final Map<String, ? extends Collection<String>> getLabelMapper() {
            return this.labelMapper;
        }

        @Override
        public final Builder labelMapper(Map<String, ? extends Collection<String>> labelMapper) {
            this.labelMapper = LabelMapperCopier.copy(labelMapper);
            return this;
        }

        public final void setLabelMapper(Map<String, ? extends Collection<String>> labelMapper) {
            this.labelMapper = LabelMapperCopier.copy(labelMapper);
        }

        public LabelSchema build() {
            return new LabelSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelSchema> {
        public Builder labelKey(String var1);

        public Builder labelMapper(Map<String, ? extends Collection<String>> var1);
    }
}

