/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a listener attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListenerAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<ListenerAttribute.Builder, ListenerAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(ListenerAttribute::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ListenerAttribute::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private ListenerAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tcp.idle_timeout.seconds</code> - The tcp idle timeout value, in seconds. The valid range is 60-6000
     * seconds. The default is 350 seconds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are only supported by Application Load Balancers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name</code> - Enables you to modify the
     * header name of the <b>X-Amzn-Mtls-Clientcert-Serial-Number</b> HTTP request header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.request.x_amzn_mtls_clientcert_issuer.header_name</code> - Enables you to modify the header
     * name of the <b>X-Amzn-Mtls-Clientcert-Issuer</b> HTTP request header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.request.x_amzn_mtls_clientcert_subject.header_name</code> - Enables you to modify the header
     * name of the <b>X-Amzn-Mtls-Clientcert-Subject</b> HTTP request header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.request.x_amzn_mtls_clientcert_validity.header_name</code> - Enables you to modify the header
     * name of the <b>X-Amzn-Mtls-Clientcert-Validity</b> HTTP request header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.request.x_amzn_mtls_clientcert_leaf.header_name</code> - Enables you to modify the header name
     * of the <b>X-Amzn-Mtls-Clientcert-Leaf</b> HTTP request header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.request.x_amzn_mtls_clientcert.header_name</code> - Enables you to modify the header name of
     * the <b>X-Amzn-Mtls-Clientcert</b> HTTP request header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.request.x_amzn_tls_version.header_name</code> - Enables you to modify the header name of the
     * <b>X-Amzn-Tls-Version</b> HTTP request header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.request.x_amzn_tls_cipher_suite.header_name</code> - Enables you to modify the header name of
     * the <b>X-Amzn-Tls-Cipher-Suite</b> HTTP request header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.server.enabled</code> - Enables you to allow or remove the HTTP response server
     * header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.strict_transport_security.header_value</code> - Informs browsers that the site should
     * only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be
     * converted to HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.access_control_allow_origin.header_value</code> - Specifies which origins are allowed
     * to access the server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.access_control_allow_methods.header_value</code> - Returns which HTTP methods are
     * allowed when accessing the server from a different origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.access_control_allow_headers.header_value</code> - Specifies which headers can be
     * used during the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.access_control_allow_credentials.header_value</code> - Indicates whether the browser
     * should include credentials such as cookies or authentication when making requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.access_control_expose_headers.header_value</code> - Returns which headers the browser
     * can expose to the requesting client.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.access_control_max_age.header_value</code> - Specifies how long the results of a
     * preflight request can be cached, in seconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.content_security_policy.header_value</code> - Specifies restrictions enforced by the
     * browser to help minimize the risk of certain types of security threats.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.x_content_type_options.header_value</code> - Indicates whether the MIME types
     * advertised in the <b>Content-Type</b> headers should be followed and not be changed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.response.x_frame_options.header_value</code> - Indicates whether the browser is allowed to
     * render a page in a <b>frame</b>, <b>iframe</b>, <b>embed</b> or <b>object</b>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the attribute.</p>
     *         <p>
     *         The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>tcp.idle_timeout.seconds</code> - The tcp idle timeout value, in seconds. The valid range is
     *         60-6000 seconds. The default is 350 seconds.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are only supported by Application Load Balancers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name</code> - Enables you to
     *         modify the header name of the <b>X-Amzn-Mtls-Clientcert-Serial-Number</b> HTTP request header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.request.x_amzn_mtls_clientcert_issuer.header_name</code> - Enables you to modify the
     *         header name of the <b>X-Amzn-Mtls-Clientcert-Issuer</b> HTTP request header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.request.x_amzn_mtls_clientcert_subject.header_name</code> - Enables you to modify the
     *         header name of the <b>X-Amzn-Mtls-Clientcert-Subject</b> HTTP request header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.request.x_amzn_mtls_clientcert_validity.header_name</code> - Enables you to modify the
     *         header name of the <b>X-Amzn-Mtls-Clientcert-Validity</b> HTTP request header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.request.x_amzn_mtls_clientcert_leaf.header_name</code> - Enables you to modify the
     *         header name of the <b>X-Amzn-Mtls-Clientcert-Leaf</b> HTTP request header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.request.x_amzn_mtls_clientcert.header_name</code> - Enables you to modify the header
     *         name of the <b>X-Amzn-Mtls-Clientcert</b> HTTP request header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.request.x_amzn_tls_version.header_name</code> - Enables you to modify the header name
     *         of the <b>X-Amzn-Tls-Version</b> HTTP request header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.request.x_amzn_tls_cipher_suite.header_name</code> - Enables you to modify the header
     *         name of the <b>X-Amzn-Tls-Cipher-Suite</b> HTTP request header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.server.enabled</code> - Enables you to allow or remove the HTTP response
     *         server header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.strict_transport_security.header_value</code> - Informs browsers that the
     *         site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should
     *         automatically be converted to HTTPS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.access_control_allow_origin.header_value</code> - Specifies which origins are
     *         allowed to access the server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.access_control_allow_methods.header_value</code> - Returns which HTTP methods
     *         are allowed when accessing the server from a different origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.access_control_allow_headers.header_value</code> - Specifies which headers
     *         can be used during the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.access_control_allow_credentials.header_value</code> - Indicates whether the
     *         browser should include credentials such as cookies or authentication when making requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.access_control_expose_headers.header_value</code> - Returns which headers the
     *         browser can expose to the requesting client.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.access_control_max_age.header_value</code> - Specifies how long the results
     *         of a preflight request can be cached, in seconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.content_security_policy.header_value</code> - Specifies restrictions enforced
     *         by the browser to help minimize the risk of certain types of security threats.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.x_content_type_options.header_value</code> - Indicates whether the MIME types
     *         advertised in the <b>Content-Type</b> headers should be followed and not be changed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.response.x_frame_options.header_value</code> - Indicates whether the browser is
     *         allowed to render a page in a <b>frame</b>, <b>iframe</b>, <b>embed</b> or <b>object</b>.
     *         </p>
     *         </li>
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerAttribute)) {
            return false;
        }
        ListenerAttribute other = (ListenerAttribute) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListenerAttribute").add("Key", key()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListenerAttribute, T> g) {
        return obj -> g.apply((ListenerAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListenerAttribute> {
        /**
         * <p>
         * The name of the attribute.
         * </p>
         * <p>
         * The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tcp.idle_timeout.seconds</code> - The tcp idle timeout value, in seconds. The valid range is 60-6000
         * seconds. The default is 350 seconds.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes are only supported by Application Load Balancers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name</code> - Enables you to modify
         * the header name of the <b>X-Amzn-Mtls-Clientcert-Serial-Number</b> HTTP request header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.request.x_amzn_mtls_clientcert_issuer.header_name</code> - Enables you to modify the
         * header name of the <b>X-Amzn-Mtls-Clientcert-Issuer</b> HTTP request header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.request.x_amzn_mtls_clientcert_subject.header_name</code> - Enables you to modify the
         * header name of the <b>X-Amzn-Mtls-Clientcert-Subject</b> HTTP request header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.request.x_amzn_mtls_clientcert_validity.header_name</code> - Enables you to modify the
         * header name of the <b>X-Amzn-Mtls-Clientcert-Validity</b> HTTP request header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.request.x_amzn_mtls_clientcert_leaf.header_name</code> - Enables you to modify the header
         * name of the <b>X-Amzn-Mtls-Clientcert-Leaf</b> HTTP request header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.request.x_amzn_mtls_clientcert.header_name</code> - Enables you to modify the header name
         * of the <b>X-Amzn-Mtls-Clientcert</b> HTTP request header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.request.x_amzn_tls_version.header_name</code> - Enables you to modify the header name of
         * the <b>X-Amzn-Tls-Version</b> HTTP request header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.request.x_amzn_tls_cipher_suite.header_name</code> - Enables you to modify the header name
         * of the <b>X-Amzn-Tls-Cipher-Suite</b> HTTP request header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.server.enabled</code> - Enables you to allow or remove the HTTP response server
         * header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.strict_transport_security.header_value</code> - Informs browsers that the site
         * should only be accessed using HTTPS, and that any future attempts to access it using HTTP should
         * automatically be converted to HTTPS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.access_control_allow_origin.header_value</code> - Specifies which origins are
         * allowed to access the server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.access_control_allow_methods.header_value</code> - Returns which HTTP methods are
         * allowed when accessing the server from a different origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.access_control_allow_headers.header_value</code> - Specifies which headers can be
         * used during the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.access_control_allow_credentials.header_value</code> - Indicates whether the
         * browser should include credentials such as cookies or authentication when making requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.access_control_expose_headers.header_value</code> - Returns which headers the
         * browser can expose to the requesting client.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.access_control_max_age.header_value</code> - Specifies how long the results of a
         * preflight request can be cached, in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.content_security_policy.header_value</code> - Specifies restrictions enforced by
         * the browser to help minimize the risk of certain types of security threats.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.x_content_type_options.header_value</code> - Indicates whether the MIME types
         * advertised in the <b>Content-Type</b> headers should be followed and not be changed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.response.x_frame_options.header_value</code> - Indicates whether the browser is allowed to
         * render a page in a <b>frame</b>, <b>iframe</b>, <b>embed</b> or <b>object</b>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param key
         *        The name of the attribute.</p>
         *        <p>
         *        The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tcp.idle_timeout.seconds</code> - The tcp idle timeout value, in seconds. The valid range is
         *        60-6000 seconds. The default is 350 seconds.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are only supported by Application Load Balancers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name</code> - Enables you to
         *        modify the header name of the <b>X-Amzn-Mtls-Clientcert-Serial-Number</b> HTTP request header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.request.x_amzn_mtls_clientcert_issuer.header_name</code> - Enables you to modify
         *        the header name of the <b>X-Amzn-Mtls-Clientcert-Issuer</b> HTTP request header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.request.x_amzn_mtls_clientcert_subject.header_name</code> - Enables you to modify
         *        the header name of the <b>X-Amzn-Mtls-Clientcert-Subject</b> HTTP request header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.request.x_amzn_mtls_clientcert_validity.header_name</code> - Enables you to modify
         *        the header name of the <b>X-Amzn-Mtls-Clientcert-Validity</b> HTTP request header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.request.x_amzn_mtls_clientcert_leaf.header_name</code> - Enables you to modify the
         *        header name of the <b>X-Amzn-Mtls-Clientcert-Leaf</b> HTTP request header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.request.x_amzn_mtls_clientcert.header_name</code> - Enables you to modify the
         *        header name of the <b>X-Amzn-Mtls-Clientcert</b> HTTP request header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.request.x_amzn_tls_version.header_name</code> - Enables you to modify the header
         *        name of the <b>X-Amzn-Tls-Version</b> HTTP request header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.request.x_amzn_tls_cipher_suite.header_name</code> - Enables you to modify the
         *        header name of the <b>X-Amzn-Tls-Cipher-Suite</b> HTTP request header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.server.enabled</code> - Enables you to allow or remove the HTTP response
         *        server header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.strict_transport_security.header_value</code> - Informs browsers that the
         *        site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should
         *        automatically be converted to HTTPS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.access_control_allow_origin.header_value</code> - Specifies which origins
         *        are allowed to access the server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.access_control_allow_methods.header_value</code> - Returns which HTTP
         *        methods are allowed when accessing the server from a different origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.access_control_allow_headers.header_value</code> - Specifies which headers
         *        can be used during the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.access_control_allow_credentials.header_value</code> - Indicates whether
         *        the browser should include credentials such as cookies or authentication when making requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.access_control_expose_headers.header_value</code> - Returns which headers
         *        the browser can expose to the requesting client.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.access_control_max_age.header_value</code> - Specifies how long the
         *        results of a preflight request can be cached, in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.content_security_policy.header_value</code> - Specifies restrictions
         *        enforced by the browser to help minimize the risk of certain types of security threats.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.x_content_type_options.header_value</code> - Indicates whether the MIME
         *        types advertised in the <b>Content-Type</b> headers should be followed and not be changed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.response.x_frame_options.header_value</code> - Indicates whether the browser is
         *        allowed to render a page in a <b>frame</b>, <b>iframe</b>, <b>embed</b> or <b>object</b>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * 
         * @param value
         *        The value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerAttribute model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public ListenerAttribute build() {
            return new ListenerAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
