/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyListenerAttributesRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<ModifyListenerAttributesRequest.Builder, ModifyListenerAttributesRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListenerArn").getter(getter(ModifyListenerAttributesRequest::listenerArn))
            .setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<List<ListenerAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<ListenerAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(ModifyListenerAttributesRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListenerAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListenerAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            ATTRIBUTES_FIELD));

    private final String listenerArn;

    private final List<ListenerAttribute> attributes;

    private ModifyListenerAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public final String listenerArn() {
        return listenerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listener attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The listener attributes.
     */
    public final List<ListenerAttribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyListenerAttributesRequest)) {
            return false;
        }
        ModifyListenerAttributesRequest other = (ModifyListenerAttributesRequest) obj;
        return Objects.equals(listenerArn(), other.listenerArn()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyListenerAttributesRequest").add("ListenerArn", listenerArn())
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyListenerAttributesRequest, T> g) {
        return obj -> g.apply((ModifyListenerAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyListenerAttributesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The listener attributes.
         * </p>
         * 
         * @param attributes
         *        The listener attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<ListenerAttribute> attributes);

        /**
         * <p>
         * The listener attributes.
         * </p>
         * 
         * @param attributes
         *        The listener attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(ListenerAttribute... attributes);

        /**
         * <p>
         * The listener attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerAttribute.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerAttribute.Builder#build()} is
         * called immediately and its result is passed to {@link #attributes(List<ListenerAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<ListenerAttribute>)
         */
        Builder attributes(Consumer<ListenerAttribute.Builder>... attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String listenerArn;

        private List<ListenerAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyListenerAttributesRequest model) {
            super(model);
            listenerArn(model.listenerArn);
            attributes(model.attributes);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final List<ListenerAttribute.Builder> getAttributes() {
            List<ListenerAttribute.Builder> result = ListenerAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<ListenerAttribute.BuilderImpl> attributes) {
            this.attributes = ListenerAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<ListenerAttribute> attributes) {
            this.attributes = ListenerAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(ListenerAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<ListenerAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> ListenerAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyListenerAttributesRequest build() {
            return new ModifyListenerAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
