/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheUsageLimits;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyServerlessCacheRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyServerlessCacheRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerlessCacheName").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::serverlessCacheName)).setter(ModifyServerlessCacheRequest.setter(Builder::serverlessCacheName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::description)).setter(ModifyServerlessCacheRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<CacheUsageLimits> CACHE_USAGE_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheUsageLimits").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::cacheUsageLimits)).setter(ModifyServerlessCacheRequest.setter(Builder::cacheUsageLimits)).constructor(CacheUsageLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheUsageLimits").build()}).build();
    private static final SdkField<Boolean> REMOVE_USER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveUserGroup").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::removeUserGroup)).setter(ModifyServerlessCacheRequest.setter(Builder::removeUserGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveUserGroup").build()}).build();
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserGroupId").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::userGroupId)).setter(ModifyServerlessCacheRequest.setter(Builder::userGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::securityGroupIds)).setter(ModifyServerlessCacheRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::snapshotRetentionLimit)).setter(ModifyServerlessCacheRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> DAILY_SNAPSHOT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailySnapshotTime").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::dailySnapshotTime)).setter(ModifyServerlessCacheRequest.setter(Builder::dailySnapshotTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailySnapshotTime").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::engine)).setter(ModifyServerlessCacheRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorEngineVersion").getter(ModifyServerlessCacheRequest.getter(ModifyServerlessCacheRequest::majorEngineVersion)).setter(ModifyServerlessCacheRequest.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD, DESCRIPTION_FIELD, CACHE_USAGE_LIMITS_FIELD, REMOVE_USER_GROUP_FIELD, USER_GROUP_ID_FIELD, SECURITY_GROUP_IDS_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, DAILY_SNAPSHOT_TIME_FIELD, ENGINE_FIELD, MAJOR_ENGINE_VERSION_FIELD));
    private final String serverlessCacheName;
    private final String description;
    private final CacheUsageLimits cacheUsageLimits;
    private final Boolean removeUserGroup;
    private final String userGroupId;
    private final List<String> securityGroupIds;
    private final Integer snapshotRetentionLimit;
    private final String dailySnapshotTime;
    private final String engine;
    private final String majorEngineVersion;

    private ModifyServerlessCacheRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheName = builder.serverlessCacheName;
        this.description = builder.description;
        this.cacheUsageLimits = builder.cacheUsageLimits;
        this.removeUserGroup = builder.removeUserGroup;
        this.userGroupId = builder.userGroupId;
        this.securityGroupIds = builder.securityGroupIds;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.dailySnapshotTime = builder.dailySnapshotTime;
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
    }

    public final String serverlessCacheName() {
        return this.serverlessCacheName;
    }

    public final String description() {
        return this.description;
    }

    public final CacheUsageLimits cacheUsageLimits() {
        return this.cacheUsageLimits;
    }

    public final Boolean removeUserGroup() {
        return this.removeUserGroup;
    }

    public final String userGroupId() {
        return this.userGroupId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String dailySnapshotTime() {
        return this.dailySnapshotTime;
    }

    public final String engine() {
        return this.engine;
    }

    public final String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheUsageLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeUserGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailySnapshotTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyServerlessCacheRequest)) {
            return false;
        }
        ModifyServerlessCacheRequest other = (ModifyServerlessCacheRequest)((Object)obj);
        return Objects.equals(this.serverlessCacheName(), other.serverlessCacheName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cacheUsageLimits(), other.cacheUsageLimits()) && Objects.equals(this.removeUserGroup(), other.removeUserGroup()) && Objects.equals(this.userGroupId(), other.userGroupId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.dailySnapshotTime(), other.dailySnapshotTime()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyServerlessCacheRequest").add("ServerlessCacheName", (Object)this.serverlessCacheName()).add("Description", (Object)this.description()).add("CacheUsageLimits", (Object)this.cacheUsageLimits()).add("RemoveUserGroup", (Object)this.removeUserGroup()).add("UserGroupId", (Object)this.userGroupId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("DailySnapshotTime", (Object)this.dailySnapshotTime()).add("Engine", (Object)this.engine()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerlessCacheName": {
                return Optional.ofNullable(clazz.cast(this.serverlessCacheName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CacheUsageLimits": {
                return Optional.ofNullable(clazz.cast(this.cacheUsageLimits()));
            }
            case "RemoveUserGroup": {
                return Optional.ofNullable(clazz.cast(this.removeUserGroup()));
            }
            case "UserGroupId": {
                return Optional.ofNullable(clazz.cast(this.userGroupId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "DailySnapshotTime": {
                return Optional.ofNullable(clazz.cast(this.dailySnapshotTime()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyServerlessCacheRequest, T> g) {
        return obj -> g.apply((ModifyServerlessCacheRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String serverlessCacheName;
        private String description;
        private CacheUsageLimits cacheUsageLimits;
        private Boolean removeUserGroup;
        private String userGroupId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Integer snapshotRetentionLimit;
        private String dailySnapshotTime;
        private String engine;
        private String majorEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyServerlessCacheRequest model) {
            super(model);
            this.serverlessCacheName(model.serverlessCacheName);
            this.description(model.description);
            this.cacheUsageLimits(model.cacheUsageLimits);
            this.removeUserGroup(model.removeUserGroup);
            this.userGroupId(model.userGroupId);
            this.securityGroupIds(model.securityGroupIds);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.dailySnapshotTime(model.dailySnapshotTime);
            this.engine(model.engine);
            this.majorEngineVersion(model.majorEngineVersion);
        }

        public final String getServerlessCacheName() {
            return this.serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CacheUsageLimits.Builder getCacheUsageLimits() {
            return this.cacheUsageLimits != null ? this.cacheUsageLimits.toBuilder() : null;
        }

        public final void setCacheUsageLimits(CacheUsageLimits.BuilderImpl cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits != null ? cacheUsageLimits.build() : null;
        }

        @Override
        public final Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits;
            return this;
        }

        public final Boolean getRemoveUserGroup() {
            return this.removeUserGroup;
        }

        public final void setRemoveUserGroup(Boolean removeUserGroup) {
            this.removeUserGroup = removeUserGroup;
        }

        @Override
        public final Builder removeUserGroup(Boolean removeUserGroup) {
            this.removeUserGroup = removeUserGroup;
            return this;
        }

        public final String getUserGroupId() {
            return this.userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getDailySnapshotTime() {
            return this.dailySnapshotTime;
        }

        public final void setDailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
        }

        @Override
        public final Builder dailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyServerlessCacheRequest build() {
            return new ModifyServerlessCacheRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyServerlessCacheRequest> {
        public Builder serverlessCacheName(String var1);

        public Builder description(String var1);

        public Builder cacheUsageLimits(CacheUsageLimits var1);

        default public Builder cacheUsageLimits(Consumer<CacheUsageLimits.Builder> cacheUsageLimits) {
            return this.cacheUsageLimits((CacheUsageLimits)((CacheUsageLimits.Builder)CacheUsageLimits.builder().applyMutation(cacheUsageLimits)).build());
        }

        public Builder removeUserGroup(Boolean var1);

        public Builder userGroupId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder dailySnapshotTime(String var1);

        public Builder engine(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

