/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDeploymentBrief
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDeploymentBrief> {
    private static final SdkField<String> SERVICE_DEPLOYMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceDeploymentArn").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::serviceDeploymentArn)).setter(ServiceDeploymentBrief.setter(Builder::serviceDeploymentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeploymentArn").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::serviceArn)).setter(ServiceDeploymentBrief.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::clusterArn)).setter(ServiceDeploymentBrief.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::startedAt)).setter(ServiceDeploymentBrief.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::createdAt)).setter(ServiceDeploymentBrief.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("finishedAt").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::finishedAt)).setter(ServiceDeploymentBrief.setter(Builder::finishedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finishedAt").build()}).build();
    private static final SdkField<String> TARGET_SERVICE_REVISION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetServiceRevisionArn").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::targetServiceRevisionArn)).setter(ServiceDeploymentBrief.setter(Builder::targetServiceRevisionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetServiceRevisionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::statusAsString)).setter(ServiceDeploymentBrief.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(ServiceDeploymentBrief.getter(ServiceDeploymentBrief::statusReason)).setter(ServiceDeploymentBrief.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENT_ARN_FIELD, SERVICE_ARN_FIELD, CLUSTER_ARN_FIELD, STARTED_AT_FIELD, CREATED_AT_FIELD, FINISHED_AT_FIELD, TARGET_SERVICE_REVISION_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceDeploymentBrief.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceDeploymentArn;
    private final String serviceArn;
    private final String clusterArn;
    private final Instant startedAt;
    private final Instant createdAt;
    private final Instant finishedAt;
    private final String targetServiceRevisionArn;
    private final String status;
    private final String statusReason;

    private ServiceDeploymentBrief(BuilderImpl builder) {
        this.serviceDeploymentArn = builder.serviceDeploymentArn;
        this.serviceArn = builder.serviceArn;
        this.clusterArn = builder.clusterArn;
        this.startedAt = builder.startedAt;
        this.createdAt = builder.createdAt;
        this.finishedAt = builder.finishedAt;
        this.targetServiceRevisionArn = builder.targetServiceRevisionArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String serviceDeploymentArn() {
        return this.serviceDeploymentArn;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant finishedAt() {
        return this.finishedAt;
    }

    public final String targetServiceRevisionArn() {
        return this.targetServiceRevisionArn;
    }

    public final ServiceDeploymentStatus status() {
        return ServiceDeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetServiceRevisionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDeploymentBrief)) {
            return false;
        }
        ServiceDeploymentBrief other = (ServiceDeploymentBrief)obj;
        return Objects.equals(this.serviceDeploymentArn(), other.serviceDeploymentArn()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.finishedAt(), other.finishedAt()) && Objects.equals(this.targetServiceRevisionArn(), other.targetServiceRevisionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceDeploymentBrief").add("ServiceDeploymentArn", (Object)this.serviceDeploymentArn()).add("ServiceArn", (Object)this.serviceArn()).add("ClusterArn", (Object)this.clusterArn()).add("StartedAt", (Object)this.startedAt()).add("CreatedAt", (Object)this.createdAt()).add("FinishedAt", (Object)this.finishedAt()).add("TargetServiceRevisionArn", (Object)this.targetServiceRevisionArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceDeploymentArn": {
                return Optional.ofNullable(clazz.cast(this.serviceDeploymentArn()));
            }
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "finishedAt": {
                return Optional.ofNullable(clazz.cast(this.finishedAt()));
            }
            case "targetServiceRevisionArn": {
                return Optional.ofNullable(clazz.cast(this.targetServiceRevisionArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceDeploymentArn", SERVICE_DEPLOYMENT_ARN_FIELD);
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("finishedAt", FINISHED_AT_FIELD);
        map.put("targetServiceRevisionArn", TARGET_SERVICE_REVISION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceDeploymentBrief, T> g) {
        return obj -> g.apply((ServiceDeploymentBrief)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceDeploymentArn;
        private String serviceArn;
        private String clusterArn;
        private Instant startedAt;
        private Instant createdAt;
        private Instant finishedAt;
        private String targetServiceRevisionArn;
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDeploymentBrief model) {
            this.serviceDeploymentArn(model.serviceDeploymentArn);
            this.serviceArn(model.serviceArn);
            this.clusterArn(model.clusterArn);
            this.startedAt(model.startedAt);
            this.createdAt(model.createdAt);
            this.finishedAt(model.finishedAt);
            this.targetServiceRevisionArn(model.targetServiceRevisionArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getServiceDeploymentArn() {
            return this.serviceDeploymentArn;
        }

        public final void setServiceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
        }

        @Override
        public final Builder serviceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final String getTargetServiceRevisionArn() {
            return this.targetServiceRevisionArn;
        }

        public final void setTargetServiceRevisionArn(String targetServiceRevisionArn) {
            this.targetServiceRevisionArn = targetServiceRevisionArn;
        }

        @Override
        public final Builder targetServiceRevisionArn(String targetServiceRevisionArn) {
            this.targetServiceRevisionArn = targetServiceRevisionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public ServiceDeploymentBrief build() {
            return new ServiceDeploymentBrief(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDeploymentBrief> {
        public Builder serviceDeploymentArn(String var1);

        public Builder serviceArn(String var1);

        public Builder clusterArn(String var1);

        public Builder startedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder finishedAt(Instant var1);

        public Builder targetServiceRevisionArn(String var1);

        public Builder status(String var1);

        public Builder status(ServiceDeploymentStatus var1);

        public Builder statusReason(String var1);
    }
}

