/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceRevisionsRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DescribeServiceRevisionsRequest> {
    private static final SdkField<List<String>> SERVICE_REVISION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceRevisionArns").getter(DescribeServiceRevisionsRequest.getter(DescribeServiceRevisionsRequest::serviceRevisionArns)).setter(DescribeServiceRevisionsRequest.setter(Builder::serviceRevisionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRevisionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_REVISION_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceRevisionsRequest.memberNameToFieldInitializer();
    private final List<String> serviceRevisionArns;

    private DescribeServiceRevisionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceRevisionArns = builder.serviceRevisionArns;
    }

    public final boolean hasServiceRevisionArns() {
        return this.serviceRevisionArns != null && !(this.serviceRevisionArns instanceof SdkAutoConstructList);
    }

    public final List<String> serviceRevisionArns() {
        return this.serviceRevisionArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceRevisionArns() ? this.serviceRevisionArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceRevisionsRequest)) {
            return false;
        }
        DescribeServiceRevisionsRequest other = (DescribeServiceRevisionsRequest)((Object)obj);
        return this.hasServiceRevisionArns() == other.hasServiceRevisionArns() && Objects.equals(this.serviceRevisionArns(), other.serviceRevisionArns());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceRevisionsRequest").add("ServiceRevisionArns", this.hasServiceRevisionArns() ? this.serviceRevisionArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceRevisionArns": {
                return Optional.ofNullable(clazz.cast(this.serviceRevisionArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("serviceRevisionArns", SERVICE_REVISION_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceRevisionsRequest, T> g) {
        return obj -> g.apply((DescribeServiceRevisionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private List<String> serviceRevisionArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceRevisionsRequest model) {
            super(model);
            this.serviceRevisionArns(model.serviceRevisionArns);
        }

        public final Collection<String> getServiceRevisionArns() {
            if (this.serviceRevisionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceRevisionArns;
        }

        public final void setServiceRevisionArns(Collection<String> serviceRevisionArns) {
            this.serviceRevisionArns = StringListCopier.copy(serviceRevisionArns);
        }

        @Override
        public final Builder serviceRevisionArns(Collection<String> serviceRevisionArns) {
            this.serviceRevisionArns = StringListCopier.copy(serviceRevisionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRevisionArns(String ... serviceRevisionArns) {
            this.serviceRevisionArns(Arrays.asList(serviceRevisionArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceRevisionsRequest build() {
            return new DescribeServiceRevisionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceRevisionsRequest> {
        public Builder serviceRevisionArns(Collection<String> var1);

        public Builder serviceRevisionArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

