/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.ecr.auth.scheme.EcrAuthSchemeParams;
import software.amazon.awssdk.services.ecr.auth.scheme.internal.DefaultEcrAuthSchemeProvider;
import software.amazon.awssdk.services.ecr.auth.scheme.internal.PreferredEcrAuthSchemeProvider;

@SdkPublicApi
public interface EcrAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(EcrAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<EcrAuthSchemeParams.Builder> consumer) {
        EcrAuthSchemeParams.Builder builder = EcrAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static EcrAuthSchemeProvider defaultProvider() {
        return DefaultEcrAuthSchemeProvider.create();
    }

    public static EcrAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredEcrAuthSchemeProvider(EcrAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

