/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.UserBucketDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotTaskDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotTaskDetail> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::description)).setter(SnapshotTaskDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Double> DISK_IMAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DiskImageSize").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::diskImageSize)).setter(SnapshotTaskDetail.setter(Builder::diskImageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageSize").unmarshallLocationName("diskImageSize").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::encrypted)).setter(SnapshotTaskDetail.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::format)).setter(SnapshotTaskDetail.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("format").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::kmsKeyId)).setter(SnapshotTaskDetail.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("kmsKeyId").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Progress").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::progress)).setter(SnapshotTaskDetail.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::snapshotId)).setter(SnapshotTaskDetail.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::status)).setter(SnapshotTaskDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::statusMessage)).setter(SnapshotTaskDetail.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::url)).setter(SnapshotTaskDetail.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").unmarshallLocationName("url").build()}).build();
    private static final SdkField<UserBucketDetails> USER_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserBucket").getter(SnapshotTaskDetail.getter(SnapshotTaskDetail::userBucket)).setter(SnapshotTaskDetail.setter(Builder::userBucket)).constructor(UserBucketDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBucket").unmarshallLocationName("userBucket").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISK_IMAGE_SIZE_FIELD, ENCRYPTED_FIELD, FORMAT_FIELD, KMS_KEY_ID_FIELD, PROGRESS_FIELD, SNAPSHOT_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, URL_FIELD, USER_BUCKET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnapshotTaskDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Double diskImageSize;
    private final Boolean encrypted;
    private final String format;
    private final String kmsKeyId;
    private final String progress;
    private final String snapshotId;
    private final String status;
    private final String statusMessage;
    private final String url;
    private final UserBucketDetails userBucket;

    private SnapshotTaskDetail(BuilderImpl builder) {
        this.description = builder.description;
        this.diskImageSize = builder.diskImageSize;
        this.encrypted = builder.encrypted;
        this.format = builder.format;
        this.kmsKeyId = builder.kmsKeyId;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    public final String description() {
        return this.description;
    }

    public final Double diskImageSize() {
        return this.diskImageSize;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String format() {
        return this.format;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String progress() {
        return this.progress;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String status() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String url() {
        return this.url;
    }

    public final UserBucketDetails userBucket() {
        return this.userBucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.userBucket());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotTaskDetail)) {
            return false;
        }
        SnapshotTaskDetail other = (SnapshotTaskDetail)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.diskImageSize(), other.diskImageSize()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.userBucket(), other.userBucket());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotTaskDetail").add("Description", (Object)this.description()).add("DiskImageSize", (Object)this.diskImageSize()).add("Encrypted", (Object)this.encrypted()).add("Format", (Object)this.format()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Progress", (Object)this.progress()).add("SnapshotId", (Object)this.snapshotId()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("UserBucket", (Object)this.userBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiskImageSize": {
                return Optional.ofNullable(clazz.cast(this.diskImageSize()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "UserBucket": {
                return Optional.ofNullable(clazz.cast(this.userBucket()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DiskImageSize", DISK_IMAGE_SIZE_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("Url", URL_FIELD);
        map.put("UserBucket", USER_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotTaskDetail, T> g) {
        return obj -> g.apply((SnapshotTaskDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Double diskImageSize;
        private Boolean encrypted;
        private String format;
        private String kmsKeyId;
        private String progress;
        private String snapshotId;
        private String status;
        private String statusMessage;
        private String url;
        private UserBucketDetails userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotTaskDetail model) {
            this.description(model.description);
            this.diskImageSize(model.diskImageSize);
            this.encrypted(model.encrypted);
            this.format(model.format);
            this.kmsKeyId(model.kmsKeyId);
            this.progress(model.progress);
            this.snapshotId(model.snapshotId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.url(model.url);
            this.userBucket(model.userBucket);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Double getDiskImageSize() {
            return this.diskImageSize;
        }

        public final void setDiskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
        }

        @Override
        public final Builder diskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getProgress() {
            return this.progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final UserBucketDetails.Builder getUserBucket() {
            return this.userBucket != null ? this.userBucket.toBuilder() : null;
        }

        public final void setUserBucket(UserBucketDetails.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        @Override
        public final Builder userBucket(UserBucketDetails userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public SnapshotTaskDetail build() {
            return new SnapshotTaskDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotTaskDetail> {
        public Builder description(String var1);

        public Builder diskImageSize(Double var1);

        public Builder encrypted(Boolean var1);

        public Builder format(String var1);

        public Builder kmsKeyId(String var1);

        public Builder progress(String var1);

        public Builder snapshotId(String var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder url(String var1);

        public Builder userBucket(UserBucketDetails var1);

        default public Builder userBucket(Consumer<UserBucketDetails.Builder> userBucket) {
            return this.userBucket((UserBucketDetails)((UserBucketDetails.Builder)UserBucketDetails.builder().applyMutation(userBucket)).build());
        }
    }
}

