/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides authorization for Amazon to bring an Autonomous System Number (ASN) to a specific Amazon Web Services
 * account using bring your own ASN (BYOASN). For details on the format of the message and signature, see <a
 * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in the
 * <i>Amazon VPC IPAM guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsnAuthorizationContext implements SdkPojo, Serializable,
        ToCopyableBuilder<AsnAuthorizationContext.Builder, AsnAuthorizationContext> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Message")
            .getter(getter(AsnAuthorizationContext::message))
            .setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message")
                    .unmarshallLocationName("Message").build()).build();

    private static final SdkField<String> SIGNATURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Signature")
            .getter(getter(AsnAuthorizationContext::signature))
            .setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature")
                    .unmarshallLocationName("Signature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MESSAGE_FIELD, SIGNATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String signature;

    private AsnAuthorizationContext(BuilderImpl builder) {
        this.message = builder.message;
        this.signature = builder.signature;
    }

    /**
     * <p>
     * The authorization context's message.
     * </p>
     * 
     * @return The authorization context's message.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The authorization context's signature.
     * </p>
     * 
     * @return The authorization context's signature.
     */
    public final String signature() {
        return signature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsnAuthorizationContext)) {
            return false;
        }
        AsnAuthorizationContext other = (AsnAuthorizationContext) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(signature(), other.signature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsnAuthorizationContext").add("Message", message()).add("Signature", signature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Signature":
            return Optional.ofNullable(clazz.cast(signature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Message", MESSAGE_FIELD);
        map.put("Signature", SIGNATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsnAuthorizationContext, T> g) {
        return obj -> g.apply((AsnAuthorizationContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsnAuthorizationContext> {
        /**
         * <p>
         * The authorization context's message.
         * </p>
         * 
         * @param message
         *        The authorization context's message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The authorization context's signature.
         * </p>
         * 
         * @param signature
         *        The authorization context's signature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(AsnAuthorizationContext model) {
            message(model.message);
            signature(model.signature);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getSignature() {
            return signature;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public AsnAuthorizationContext build() {
            return new AsnAuthorizationContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
